/*
 * Decompiled with CFR 0.152.
 */
package io.pyroscope.javaagent;

import io.pyroscope.http.Format;
import io.pyroscope.javaagent.EventType;
import io.pyroscope.javaagent.ProfilerDelegate;
import io.pyroscope.javaagent.Snapshot;
import io.pyroscope.javaagent.config.Config;
import io.pyroscope.labels.v2.Pyroscope;
import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.time.Duration;
import java.time.Instant;
import jdk.jfr.Recording;

public final class JFRJDKProfilerDelegate
implements ProfilerDelegate {
    private static final String RECORDING_NAME = "pyroscope";
    private Config config;
    private File tempJFRFile;
    private Recording recording;

    public JFRJDKProfilerDelegate(Config config) {
        this.setConfig(config);
    }

    @Override
    public void setConfig(Config config) {
        this.config = config;
        try {
            this.tempJFRFile = JFRJDKProfilerDelegate.jfrRecordingPath();
        }
        catch (IOException e) {
            throw new UncheckedIOException("cannot create JFR destination path", e);
        }
    }

    private static File jfrRecordingPath() throws IOException {
        File tempJFRFile = File.createTempFile(RECORDING_NAME, ".jfr");
        tempJFRFile.deleteOnExit();
        return tempJFRFile;
    }

    @Override
    public synchronized void start() {
        try {
            this.recording = new Recording();
            this.recording.enable("jdk.ExecutionSample").withPeriod(Duration.ofMillis(1L));
            this.recording.enable("jdk.ThreadPark").withPeriod(Duration.ofMillis(10L)).withStackTrace();
            this.recording.enable("jdk.ObjectAllocationInNewTLAB").withStackTrace();
            this.recording.enable("jdk.ObjectAllocationOutsideTLAB").withStackTrace();
            this.recording.enable("jdk.JavaMonitorEnter").withPeriod(Duration.ofMillis(10L)).withStackTrace();
            this.recording.setToDisk(true);
            this.recording.setDestination(this.tempJFRFile.toPath());
            this.recording.start();
        }
        catch (IOException e) {
            throw new UncheckedIOException("cannot start JFR recording", e);
        }
    }

    @Override
    public synchronized void stop() {
        this.recording.stop();
    }

    @Override
    public synchronized Snapshot dumpProfile(Instant started, Instant ended) {
        return this.dumpImpl(started, ended);
    }

    private Snapshot dumpImpl(Instant started, Instant ended) {
        if (this.config.gcBeforeDump) {
            System.gc();
        }
        try {
            byte[] data = Files.readAllBytes(this.tempJFRFile.toPath());
            return new Snapshot(Format.JFR, EventType.CPU, started, ended, data, Pyroscope.LabelsWrapper.dump());
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }
}

