/*
 * Decompiled with CFR 0.152.
 */
package io.pyroscope.javaagent;

import io.pyroscope.Preconditions;
import io.pyroscope.javaagent.ProfilerDelegate;
import io.pyroscope.javaagent.api.Exporter;
import io.pyroscope.javaagent.api.Logger;
import io.pyroscope.javaagent.api.ProfilingScheduler;
import io.pyroscope.javaagent.config.Config;
import io.pyroscope.javaagent.impl.ContinuousProfilingScheduler;
import io.pyroscope.javaagent.impl.DefaultConfigurationProvider;
import io.pyroscope.javaagent.impl.DefaultLogger;
import io.pyroscope.javaagent.impl.PyroscopeExporter;
import io.pyroscope.javaagent.impl.QueuedExporter;
import io.pyroscope.javaagent.impl.SamplingProfilingScheduler;
import io.pyroscope.labels.v2.ScopedContext;
import java.lang.instrument.Instrumentation;
import org.jetbrains.annotations.NotNull;

public class PyroscopeAgent {
    private static final Object sLock = new Object();
    private static Options sOptions = null;

    public static void premain(String agentArgs, Instrumentation inst) {
        Config config;
        try {
            config = Config.build(DefaultConfigurationProvider.INSTANCE);
            DefaultLogger.PRECONFIG_LOGGER.log(Logger.Level.DEBUG, "Config: %s", config);
        }
        catch (Throwable e) {
            DefaultLogger.PRECONFIG_LOGGER.log(Logger.Level.ERROR, "Error starting profiler %s", e);
            return;
        }
        PyroscopeAgent.start(config);
    }

    public static void start() {
        PyroscopeAgent.start(new Config.Builder().build());
    }

    public static void start(@NotNull Config config) {
        Preconditions.checkNotNull(config, "config");
        PyroscopeAgent.start(new Options.Builder(config).build());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void start(@NotNull Options options) {
        Preconditions.checkNotNull(options, "options");
        Object object = sLock;
        synchronized (object) {
            Logger logger = options.logger;
            if (!options.config.agentEnabled) {
                logger.log(Logger.Level.INFO, "Pyroscope agent start disabled by configuration", new Object[0]);
                return;
            }
            if (sOptions != null) {
                logger.log(Logger.Level.ERROR, "Failed to start profiling - already started", new Object[0]);
                return;
            }
            sOptions = options;
            logger.log(Logger.Level.DEBUG, "Config: %s", options.config);
            try {
                options.scheduler.start(options.profiler);
                ScopedContext.ENABLED.set(true);
                logger.log(Logger.Level.INFO, "Profiling started", new Object[0]);
            }
            catch (Throwable e) {
                logger.log(Logger.Level.ERROR, "Error starting profiler %s", e);
                sOptions = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void stop() {
        ScopedContext.ENABLED.set(false);
        Object object = sLock;
        synchronized (object) {
            if (sOptions == null) {
                DefaultLogger.PRECONFIG_LOGGER.log(Logger.Level.ERROR, "Error stopping profiler: not started", new Object[0]);
                return;
            }
            try {
                PyroscopeAgent.sOptions.scheduler.stop();
                PyroscopeAgent.sOptions.exporter.stop();
                PyroscopeAgent.sOptions.logger.log(Logger.Level.INFO, "Profiling stopped", new Object[0]);
            }
            catch (Throwable e) {
                PyroscopeAgent.sOptions.logger.log(Logger.Level.ERROR, "Error stopping profiler %s", e);
            }
            sOptions = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isStarted() {
        Object object = sLock;
        synchronized (object) {
            return sOptions != null;
        }
    }

    public static class Options {
        final Config config;
        final ProfilingScheduler scheduler;
        final Logger logger;
        final ProfilerDelegate profiler;
        final Exporter exporter;

        private Options(@NotNull Builder b) {
            this.config = b.config;
            this.profiler = b.profiler;
            this.scheduler = b.scheduler;
            this.logger = b.logger;
            this.exporter = b.exporter;
        }

        public static class Builder {
            private final Config config;
            private ProfilerDelegate profiler;
            private Exporter exporter;
            private ProfilingScheduler scheduler;
            private Logger logger;

            public Builder(@NotNull Config config) {
                Preconditions.checkNotNull(config, "config");
                this.config = config;
            }

            public Builder setExporter(@NotNull Exporter exporter) {
                Preconditions.checkNotNull(exporter, "exporter");
                this.exporter = exporter;
                return this;
            }

            public Builder setScheduler(@NotNull ProfilingScheduler scheduler) {
                Preconditions.checkNotNull(scheduler, "scheduler");
                this.scheduler = scheduler;
                return this;
            }

            public Builder setLogger(@NotNull Logger logger) {
                Preconditions.checkNotNull(logger, "logger");
                this.logger = logger;
                return this;
            }

            public Builder setProfiler(@NotNull ProfilerDelegate profiler) {
                Preconditions.checkNotNull(profiler, "logger");
                this.profiler = profiler;
                return this;
            }

            @NotNull
            public Options build() {
                if (this.logger == null) {
                    this.logger = new DefaultLogger(this.config.logLevel, System.err);
                }
                if (this.scheduler == null) {
                    if (this.exporter == null) {
                        this.exporter = new QueuedExporter(this.config, new PyroscopeExporter(this.config, this.logger), this.logger);
                    }
                    this.scheduler = this.config.samplingDuration == null ? new ContinuousProfilingScheduler(this.config, this.exporter, this.logger) : new SamplingProfilingScheduler(this.config, this.exporter, this.logger);
                }
                if (this.profiler == null) {
                    this.profiler = ProfilerDelegate.create(this.config);
                }
                return new Options(this);
            }
        }
    }
}

