/*
 * Decompiled with CFR 0.152.
 */
package io.pyroscope.javaagent.config;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.StringJoiner;
import java.util.TreeMap;
import org.jetbrains.annotations.NotNull;

public class AppName {
    final String name;
    final Map<String, String> labels;

    public AppName(String name, Map<String, String> labels) {
        this.name = name;
        this.labels = Collections.unmodifiableMap(new TreeMap<String, String>(labels));
    }

    public String toString() {
        if (this.labels.isEmpty()) {
            return this.name;
        }
        StringJoiner joinedLabels = new StringJoiner(",");
        for (Map.Entry<String, String> e : this.labels.entrySet()) {
            joinedLabels.add(e.getKey().trim() + "=" + e.getValue().trim());
        }
        return String.format("%s{%s}", this.name, joinedLabels);
    }

    public Builder newBuilder() {
        return new Builder(this.name, this.labels);
    }

    public static AppName parse(String appName) {
        int l = appName.indexOf(123);
        int r = appName.indexOf(125);
        if (l != -1 && r != -1 && l < r) {
            String name = appName.substring(0, l);
            String strLabels = appName.substring(l + 1, r);
            Map<String, String> labelsMap = AppName.parseLabels(strLabels);
            return new AppName(name, labelsMap);
        }
        return new AppName(appName, Collections.emptyMap());
    }

    @NotNull
    public static Map<String, String> parseLabels(String strLabels) {
        String[] labels = strLabels.split(",");
        HashMap<String, String> labelMap = new HashMap<String, String>();
        for (String label : labels) {
            String[] kv = label.split("=");
            if (kv.length != 2) continue;
            kv[0] = kv[0].trim();
            kv[1] = kv[1].trim();
            if (!AppName.isValidLabel(kv[0]) || !AppName.isValidLabel(kv[1])) continue;
            labelMap.put(kv[0], kv[1]);
        }
        return labelMap;
    }

    public static boolean isValidLabel(String s) {
        if (s.isEmpty()) {
            return false;
        }
        for (int i = 0; i < s.length(); ++i) {
            int c = s.codePointAt(i);
            if (c != 123 && c != 125 && c != 44 && c != 61 && c != 32) continue;
            return false;
        }
        return true;
    }

    public static class Builder {
        private String name;
        private Map<String, String> labels;

        public Builder(String name) {
            this.name = name;
            this.labels = new TreeMap<String, String>();
        }

        public Builder(String name, Map<String, String> labels) {
            this.name = name;
            this.labels = new TreeMap<String, String>(labels);
        }

        public Builder setName(String name) {
            this.name = name;
            return this;
        }

        public Builder addLabel(String k, String v) {
            if (AppName.isValidLabel(k) || AppName.isValidLabel(v)) {
                this.labels.put(k, v);
            }
            return this;
        }

        public Builder addLabels(Map<String, String> labels) {
            for (Map.Entry<String, String> it : labels.entrySet()) {
                this.addLabel(it.getKey(), it.getValue());
            }
            return this;
        }

        public AppName build() {
            return new AppName(this.name, this.labels);
        }
    }
}

