/*
 * Decompiled with CFR 0.152.
 */
package io.pyroscope.javaagent.impl;

import io.pyroscope.javaagent.api.ConfigurationProvider;
import io.pyroscope.javaagent.api.Logger;
import io.pyroscope.javaagent.impl.DefaultLogger;
import io.pyroscope.javaagent.impl.EnvConfigurationProvider;
import io.pyroscope.javaagent.impl.PropertiesConfigurationProvider;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DefaultConfigurationProvider
implements ConfigurationProvider {
    private static final String PYROSCOPE_CONFIGURATION_FILE_CONFIG = "PYROSCOPE_CONFIGURATION_FILE";
    private static final String DEFAULT_CONFIGURATION_FILE = "pyroscope.properties";
    public static final DefaultConfigurationProvider INSTANCE = new DefaultConfigurationProvider();
    final List<ConfigurationProvider> delegates = new ArrayList<ConfigurationProvider>();

    public DefaultConfigurationProvider() {
        this.delegates.add(new PropertiesConfigurationProvider(System.getProperties()));
        this.delegates.add(new EnvConfigurationProvider());
        String configFile = this.getPropertiesFile();
        try {
            this.delegates.add(new PropertiesConfigurationProvider(Files.newInputStream(Paths.get(configFile, new String[0]), new OpenOption[0])));
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            InputStream res = this.getClass().getResourceAsStream(configFile);
            if (res != null) {
                this.delegates.add(new PropertiesConfigurationProvider(res));
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (!configFile.equals(DEFAULT_CONFIGURATION_FILE) && this.delegates.size() == 2) {
            DefaultLogger.PRECONFIG_LOGGER.log(Logger.Level.WARN, "%s configuration file was specified but was not found", configFile);
        }
    }

    @Override
    @Nullable
    public String get(@NotNull String key) {
        for (int i = 0; i < this.delegates.size(); ++i) {
            String v = this.delegates.get(i).get(key);
            if (v == null) continue;
            return v;
        }
        return null;
    }

    private String getPropertiesFile() {
        String f = this.get(PYROSCOPE_CONFIGURATION_FILE_CONFIG);
        if (f == null) {
            return DEFAULT_CONFIGURATION_FILE;
        }
        return f;
    }
}

