/*
 * Decompiled with CFR 0.152.
 */
package io.pyroscope.labels.v2;

import io.pyroscope.Preconditions;
import io.pyroscope.labels.pb.JfrLabels;
import io.pyroscope.labels.v2.LabelsSet;
import io.pyroscope.labels.v2.ScopedContext;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiConsumer;
import org.jetbrains.annotations.NotNull;

public final class Pyroscope {
    private static Map<String, String> staticLabels = Collections.emptyMap();

    public static void setStaticLabels(@NotNull @NotNull Map<@NotNull String, @NotNull String> labels) {
        Preconditions.checkNotNull(labels, "Labels");
        for (Map.Entry<String, String> entry : labels.entrySet()) {
            Preconditions.checkNotNull(entry.getKey(), "Key");
            Preconditions.checkNotNull(entry.getValue(), "Value");
        }
        staticLabels = Collections.unmodifiableMap(new HashMap<String, String>(labels));
    }

    public static Map<String, String> getStaticLabels() {
        return staticLabels;
    }

    static class StringTableBuilder {
        private final Map<String, Long> indexes = new HashMap<String, Long>();

        public long get(@NotNull String s) {
            Long prev = this.indexes.get(s);
            if (prev != null) {
                return prev;
            }
            long index = this.indexes.size() + 1;
            this.indexes.put(s, index);
            return index;
        }
    }

    public static class LabelsWrapper {
        static final ConcurrentHashMap<String, Long> CONSTANTS = new ConcurrentHashMap();

        public static <T> T run(@NotNull LabelsSet labels, @NotNull Callable<T> c) throws Exception {
            try (ScopedContext s = new ScopedContext(Preconditions.checkNotNull(labels, "Labels"));){
                T t = Preconditions.checkNotNull(c, "Callable").call();
                return t;
            }
        }

        public static void run(@NotNull LabelsSet labels, @NotNull Runnable c) {
            try (ScopedContext s = new ScopedContext(Preconditions.checkNotNull(labels, "Labels"));){
                Preconditions.checkNotNull(c, "Runnable").run();
            }
        }

        public static void clear() {
            ScopedContext.CONTEXTS.clear();
        }

        public static JfrLabels.LabelsSnapshot dump() {
            JfrLabels.LabelsSnapshot.Builder sb = JfrLabels.LabelsSnapshot.newBuilder();
            StringTableBuilder stb = new StringTableBuilder();
            stb.indexes.putAll(CONSTANTS);
            HashSet<Long> closedContexts = new HashSet<Long>();
            BiConsumer<Long, LabelsSet> collect = (contextID, ls) -> {
                JfrLabels.Context.Builder cb = JfrLabels.Context.newBuilder();
                ls.forEachLabel((k, v) -> cb.putLabels(stb.get((String)k), stb.get((String)v)));
                sb.putContexts((long)contextID, cb.build());
            };
            for (Map.Entry<Long, ScopedContext> entry : ScopedContext.CONTEXTS.entrySet()) {
                Long contextID2 = entry.getKey();
                if (entry.getValue().closed.get()) {
                    closedContexts.add(contextID2);
                }
                collect.accept(contextID2, entry.getValue().labels);
            }
            for (Map.Entry<Long, Object> entry : ScopedContext.CONSTANT_CONTEXTS.entrySet()) {
                Long contextID2 = entry.getKey();
                collect.accept(contextID2, (LabelsSet)entry.getValue());
            }
            stb.indexes.forEach((k, v) -> sb.putStrings((long)v, (String)k));
            for (Long l : closedContexts) {
                ScopedContext.CONTEXTS.remove(l);
            }
            return sb.build();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static long registerConstant(@NotNull String constant) {
            Preconditions.checkNotNull(constant, "constant");
            Long v = CONSTANTS.get(constant);
            if (v != null) {
                return v;
            }
            ConcurrentHashMap<String, Long> concurrentHashMap = CONSTANTS;
            synchronized (concurrentHashMap) {
                v = CONSTANTS.get(constant);
                if (v != null) {
                    return v;
                }
                long id = CONSTANTS.size() + 1;
                CONSTANTS.put(constant, id);
                return id;
            }
        }
    }
}

