/*
 * Decompiled with CFR 0.152.
 */
package io.pyroscope.javaagent;

import io.pyroscope.Preconditions;
import io.pyroscope.PyroscopeAsyncProfiler;
import io.pyroscope.http.Format;
import io.pyroscope.javaagent.EventType;
import io.pyroscope.javaagent.ProfilerDelegate;
import io.pyroscope.javaagent.Snapshot;
import io.pyroscope.javaagent.config.Config;
import io.pyroscope.labels.v2.Pyroscope;
import io.pyroscope.vendor.one.profiler.AsyncProfiler;
import io.pyroscope.vendor.one.profiler.Counter;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.time.Instant;
import org.jetbrains.annotations.NotNull;

public final class AsyncProfilerDelegate
implements ProfilerDelegate {
    private Config config;
    private EventType eventType;
    private String alloc;
    private String lock;
    private Duration interval;
    private Format format;
    private File tempJFRFile;
    private final AsyncProfiler instance = PyroscopeAsyncProfiler.getAsyncProfiler();

    public AsyncProfilerDelegate(@NotNull Config config) {
        this.setConfig(config);
    }

    @Override
    public void setConfig(@NotNull Config config) {
        Preconditions.checkNotNull(config, "config");
        this.config = config;
        this.alloc = config.profilingAlloc;
        this.lock = config.profilingLock;
        this.eventType = config.profilingEvent;
        this.interval = config.profilingInterval;
        this.format = config.format;
        if (this.format == Format.JFR && null == this.tempJFRFile) {
            try {
                this.tempJFRFile = File.createTempFile("pyroscope", ".jfr");
                this.tempJFRFile.deleteOnExit();
            }
            catch (IOException e) {
                throw new IllegalStateException(e);
            }
        }
    }

    @Override
    public synchronized void start() {
        if (this.format == Format.JFR) {
            try {
                this.instance.execute(this.createJFRCommand());
            }
            catch (IOException e) {
                throw new IllegalStateException(e);
            }
        } else {
            this.instance.start(this.eventType.id, this.interval.toNanos());
        }
    }

    @Override
    public synchronized void stop() {
        this.instance.stop();
    }

    @Override
    @NotNull
    public synchronized Snapshot dumpProfile(@NotNull Instant started, @NotNull Instant ended) {
        return this.dumpImpl(started, ended);
    }

    private String createJFRCommand() {
        StringBuilder sb = new StringBuilder();
        sb.append("start,event=").append(this.eventType.id);
        if (this.alloc != null && !this.alloc.isEmpty()) {
            sb.append(",alloc=").append(this.alloc);
            if (this.config.allocLive) {
                sb.append(",live");
            }
        }
        if (this.lock != null && !this.lock.isEmpty()) {
            sb.append(",lock=").append(this.lock);
        }
        sb.append(",interval=").append(this.interval.toNanos()).append(",file=").append(this.tempJFRFile.toString());
        if (this.config.APLogLevel != null) {
            sb.append(",loglevel=").append(this.config.APLogLevel);
        }
        sb.append(",jstackdepth=").append(this.config.javaStackDepthMax);
        if (this.config.APExtraArguments != null) {
            sb.append(",").append(this.config.APExtraArguments);
        }
        return sb.toString();
    }

    private Snapshot dumpImpl(Instant started, Instant ended) {
        if (this.config.gcBeforeDump) {
            System.gc();
        }
        byte[] data = this.format == Format.JFR ? this.dumpJFR() : this.instance.dumpCollapsed(Counter.SAMPLES).getBytes(StandardCharsets.UTF_8);
        return new Snapshot(this.format, this.eventType, started, ended, data, Pyroscope.LabelsWrapper.dump());
    }

    private byte[] dumpJFR() {
        try {
            byte[] bytes = new byte[(int)this.tempJFRFile.length()];
            try (DataInputStream ds = new DataInputStream(new FileInputStream(this.tempJFRFile));){
                ds.readFully(bytes);
            }
            return bytes;
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }
}

