/*
 * Decompiled with CFR 0.152.
 */
package io.pyroscope.labels.v2;

import io.pyroscope.Preconditions;
import io.pyroscope.labels.v2.LabelsSet;
import io.pyroscope.labels.v2.ScopedContext;
import org.jetbrains.annotations.NotNull;

public class ConstantContext {
    private final long contextId;

    @NotNull
    public static ConstantContext of(@NotNull LabelsSet labels) {
        Preconditions.checkNotNull(labels, "Labels");
        long contextId = ScopedContext.CONTEXT_COUNTER.incrementAndGet();
        ScopedContext.CONSTANT_CONTEXTS.put(contextId, labels);
        return new ConstantContext(contextId);
    }

    private ConstantContext(long contextId) {
        this.contextId = contextId;
    }

    public void activate() {
        ScopedContext.getAsyncProfiler().setContextId(this.contextId);
    }

    public void deactivate() {
        ScopedContext.getAsyncProfiler().setContextId(0L);
    }
}

