/*
 * Decompiled with CFR 0.152.
 */
package io.pyroscope.labels.v2;

import io.pyroscope.Preconditions;
import io.pyroscope.PyroscopeAsyncProfiler;
import io.pyroscope.labels.v2.LabelsSet;
import io.pyroscope.vendor.one.profiler.AsyncProfiler;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.BiConsumer;
import org.jetbrains.annotations.NotNull;

public final class ScopedContext
implements AutoCloseable {
    public static final AtomicBoolean ENABLED = new AtomicBoolean(false);
    static final AtomicLong CONTEXT_COUNTER = new AtomicLong(0L);
    static final ConcurrentHashMap<Long, ScopedContext> CONTEXTS = new ConcurrentHashMap();
    static final ConcurrentHashMap<Long, LabelsSet> CONSTANT_CONTEXTS = new ConcurrentHashMap();
    private static volatile AsyncProfiler asyncProfiler;
    final LabelsSet labels;
    final long contextId;
    final long prevContextId;
    final AtomicBoolean closed = new AtomicBoolean(false);

    static AsyncProfiler getAsyncProfiler() {
        if (asyncProfiler != null) {
            return asyncProfiler;
        }
        asyncProfiler = PyroscopeAsyncProfiler.getAsyncProfiler();
        return asyncProfiler;
    }

    public ScopedContext(@NotNull LabelsSet labels) {
        this(Preconditions.checkNotNull(labels, "Labels"), 0L);
    }

    public ScopedContext(@NotNull LabelsSet labels, @NotNull ScopedContext prev) {
        this(Preconditions.checkNotNull(labels, "Labels"), Preconditions.checkNotNull(prev, (String)"Context").contextId);
    }

    ScopedContext(@NotNull LabelsSet labels, long prevContextId) {
        this.labels = Preconditions.checkNotNull(labels, "Labels");
        if (ENABLED.get()) {
            this.contextId = CONTEXT_COUNTER.incrementAndGet();
            this.prevContextId = prevContextId;
            CONTEXTS.put(this.contextId, this);
            ScopedContext.getAsyncProfiler().setContextId(this.contextId);
        } else {
            this.contextId = 0L;
            this.prevContextId = 0L;
        }
    }

    @Override
    public void close() {
        if (!this.closed.compareAndSet(false, true)) {
            return;
        }
        if (ENABLED.get()) {
            ScopedContext.getAsyncProfiler().setContextId(this.prevContextId);
        }
    }

    public void forEachLabel(@NotNull @NotNull BiConsumer<@NotNull String, @NotNull String> labelConsumer) {
        this.labels.forEachLabel(Preconditions.checkNotNull(labelConsumer, "Consumer"));
    }
}

