/*
 * Decompiled with CFR 0.152.
 */
package io.qameta.allure.attachment.http;

import io.qameta.allure.attachment.AttachmentData;
import io.qameta.allure.util.ObjectUtils;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class HttpResponseAttachment
implements AttachmentData {
    private final String name;
    private final String url;
    private final String body;
    private final int responseCode;
    private final Map<String, String> headers;
    private final Map<String, String> cookies;

    public HttpResponseAttachment(String name, String url, String body, int responseCode, Map<String, String> headers, Map<String, String> cookies) {
        this.name = name;
        this.url = url;
        this.body = body;
        this.responseCode = responseCode;
        this.headers = headers;
        this.cookies = cookies;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public String getUrl() {
        return this.url;
    }

    public String getBody() {
        return this.body;
    }

    public int getResponseCode() {
        return this.responseCode;
    }

    public Map<String, String> getHeaders() {
        return this.headers;
    }

    public Map<String, String> getCookies() {
        return this.cookies;
    }

    public String toString() {
        return "HttpResponseAttachment(\n\tname=" + this.name + ",\n\turl=" + this.url + ",\n\tbody=" + this.body + ",\n\tresponseCode=" + this.responseCode + ",\n\theaders=" + ObjectUtils.mapToString(this.headers) + ",\n\tcookies=" + ObjectUtils.mapToString(this.cookies) + "\n)";
    }

    public static final class Builder {
        private final String name;
        private String url;
        private int responseCode;
        private String body;
        private final Map<String, String> headers = new HashMap<String, String>();
        private final Map<String, String> cookies = new HashMap<String, String>();

        private Builder(String name) {
            Objects.requireNonNull(name, "Name must not be null value");
            this.name = name;
        }

        public static Builder create(String attachmentName) {
            return new Builder(attachmentName);
        }

        public Builder setUrl(String url) {
            Objects.requireNonNull(url, "Url must not be null value");
            this.url = url;
            return this;
        }

        public Builder setResponseCode(int responseCode) {
            this.responseCode = responseCode;
            return this;
        }

        public Builder setHeader(String name, String value) {
            Objects.requireNonNull(name, "Header name must not be null value");
            Objects.requireNonNull(value, "Header value must not be null value");
            this.headers.put(name, value);
            return this;
        }

        public Builder setHeaders(Map<String, String> headers) {
            Objects.requireNonNull(headers, "Headers must not be null value");
            this.headers.putAll(headers);
            return this;
        }

        public Builder setCookie(String name, String value) {
            Objects.requireNonNull(name, "Cookie name must not be null value");
            Objects.requireNonNull(value, "Cookie value must not be null value");
            this.cookies.put(name, value);
            return this;
        }

        public Builder setCookies(Map<String, String> cookies) {
            Objects.requireNonNull(cookies, "Cookies must not be null value");
            this.cookies.putAll(cookies);
            return this;
        }

        public Builder setBody(String body) {
            Objects.requireNonNull(body, "Body should not be null value");
            this.body = body;
            return this;
        }

        @Deprecated
        public Builder withUrl(String url) {
            return this.setUrl(url);
        }

        @Deprecated
        public Builder withResponseCode(int responseCode) {
            return this.setResponseCode(responseCode);
        }

        @Deprecated
        public Builder withHeader(String name, String value) {
            return this.setHeader(name, value);
        }

        @Deprecated
        public Builder withHeaders(Map<String, String> headers) {
            return this.setHeaders(headers);
        }

        @Deprecated
        public Builder withCookie(String name, String value) {
            return this.setCookie(name, value);
        }

        @Deprecated
        public Builder withCookies(Map<String, String> cookies) {
            return this.setCookies(cookies);
        }

        @Deprecated
        public Builder withBody(String body) {
            return this.setBody(body);
        }

        public HttpResponseAttachment build() {
            return new HttpResponseAttachment(this.name, this.url, this.body, this.responseCode, this.headers, this.cookies);
        }
    }
}

