/*
 * Decompiled with CFR 0.152.
 */
package io.qameta.allure.awaitility;

import io.qameta.allure.Allure;
import io.qameta.allure.AllureLifecycle;
import io.qameta.allure.awaitility.TemporalDuration;
import io.qameta.allure.model.Status;
import io.qameta.allure.model.StepResult;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.nio.charset.StandardCharsets;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import org.awaitility.core.ConditionEvaluationListener;
import org.awaitility.core.EvaluatedCondition;
import org.awaitility.core.IgnoredException;
import org.awaitility.core.StartEvaluationEvent;
import org.awaitility.core.TimeoutEvent;

public class AllureAwaitilityListener
implements ConditionEvaluationListener<Object> {
    private TimeUnit unit = TimeUnit.MILLISECONDS;
    private boolean logIgnoredExceptions = true;
    private final String onStartStepTextPattern;
    private final String onSatisfiedStepTextPattern;
    private final String onAwaitStepTextPattern;
    private final String onTimeoutStepTextPattern;
    private final String onExceptionStepTextPattern;
    private String currentConditionStepUUID;
    private static final InheritableThreadLocal<AllureLifecycle> LIFECYCLE = new InheritableThreadLocal<AllureLifecycle>(){

        @Override
        protected AllureLifecycle initialValue() {
            return Allure.getLifecycle();
        }
    };

    public static AllureLifecycle getLifecycle() {
        return (AllureLifecycle)LIFECYCLE.get();
    }

    public AllureAwaitilityListener() {
        this.onStartStepTextPattern = "Awaitility: %s";
        this.onSatisfiedStepTextPattern = "%s after %d %s (remaining time %d %s, last poll interval was %s)";
        this.onAwaitStepTextPattern = "%s (elapsed time %d %s, remaining time %d %s (last poll interval was %s))";
        this.onTimeoutStepTextPattern = "Condition timeout. %s";
        this.onExceptionStepTextPattern = "Exception ignored. %s";
    }

    public AllureAwaitilityListener setUnit(TimeUnit unit) {
        this.unit = unit;
        return this;
    }

    public AllureAwaitilityListener setLogIgnoredExceptions(boolean logging) {
        this.logIgnoredExceptions = logging;
        return this;
    }

    public void beforeEvaluation(StartEvaluationEvent<Object> startEvaluationEvent) {
        this.currentConditionStepUUID = UUID.randomUUID().toString();
        String nameWoAlias = String.format(this.onStartStepTextPattern, startEvaluationEvent.getDescription());
        String nameWithAlias = String.format(this.onStartStepTextPattern, startEvaluationEvent.getAlias());
        String stepName = startEvaluationEvent.getAlias() != null ? nameWithAlias : nameWoAlias;
        AllureAwaitilityListener.getLifecycle().startStep(this.currentConditionStepUUID, new StepResult().setName(stepName).setDescription("Awaitility condition started").setStatus(Status.FAILED));
    }

    public void onTimeout(TimeoutEvent timeoutEvent) {
        AllureAwaitilityListener.getLifecycle().updateStep(awaitilityCondition -> {
            String currentTimeoutStepUUID = UUID.randomUUID().toString();
            AllureAwaitilityListener.getLifecycle().startStep(this.currentConditionStepUUID, currentTimeoutStepUUID, new StepResult().setName(String.format(this.onTimeoutStepTextPattern, timeoutEvent.getDescription())).setDescription("Awaitility condition timeout").setStatus(Status.BROKEN));
            AllureAwaitilityListener.getLifecycle().stopStep(currentTimeoutStepUUID);
        });
        AllureAwaitilityListener.getLifecycle().stopStep(this.currentConditionStepUUID);
    }

    public void conditionEvaluated(EvaluatedCondition<Object> condition) {
        String description = condition.getDescription();
        long elapsedTime = this.unit.convert(condition.getElapsedTimeInMS(), TimeUnit.MILLISECONDS);
        long remainingTime = this.unit.convert(condition.getRemainingTimeInMS(), TimeUnit.MILLISECONDS);
        String unitAsString = this.unit.toString().toLowerCase();
        String message = String.format(condition.isSatisfied() ? this.onSatisfiedStepTextPattern : this.onAwaitStepTextPattern, description, elapsedTime, unitAsString, remainingTime, unitAsString, new TemporalDuration(condition.getPollInterval()));
        AllureAwaitilityListener.getLifecycle().updateStep(awaitilityCondition -> {
            String lastAwaitStepUUID = UUID.randomUUID().toString();
            AllureAwaitilityListener.getLifecycle().startStep(this.currentConditionStepUUID, lastAwaitStepUUID, new StepResult().setName(message).setDescription("Awaitility condition satisfied or not, but awaiting still in progress").setStatus(Status.PASSED));
            AllureAwaitilityListener.getLifecycle().stopStep(lastAwaitStepUUID);
            if (condition.isSatisfied()) {
                awaitilityCondition.setStatus(Status.PASSED);
                AllureAwaitilityListener.getLifecycle().stopStep(this.currentConditionStepUUID);
            }
        });
    }

    public void exceptionIgnored(IgnoredException ignoredException) {
        if (this.logIgnoredExceptions) {
            AllureAwaitilityListener.getLifecycle().updateStep(awaitilityCondition -> {
                String currentExceptionIgnoredStepUUID = UUID.randomUUID().toString();
                String message = String.format(this.onExceptionStepTextPattern, ignoredException.getThrowable().getMessage());
                StringWriter stringWriter = new StringWriter();
                ignoredException.getThrowable().printStackTrace(new PrintWriter(stringWriter));
                String stackTrace = stringWriter.toString();
                AllureAwaitilityListener.getLifecycle().startStep(this.currentConditionStepUUID, currentExceptionIgnoredStepUUID, new StepResult().setName(message).setDescription("Exception occurred and ignored, but awaiting still in progress").setStatus(Status.SKIPPED));
                AllureAwaitilityListener.getLifecycle().addAttachment(ignoredException.getThrowable().getMessage(), "text/plain", ".txt", stackTrace.getBytes(StandardCharsets.UTF_8));
                AllureAwaitilityListener.getLifecycle().stopStep(currentExceptionIgnoredStepUUID);
            });
        }
    }

    public static void setLifecycle(AllureLifecycle allure) {
        LIFECYCLE.set(allure);
    }
}

