/*
 * Decompiled with CFR 0.152.
 */
package io.qameta.allure.category;

import io.qameta.allure.category.Category;
import io.qameta.allure.entity.TestResult;
import io.qameta.allure.metric.Metric;
import io.qameta.allure.metric.MetricLine;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.BiFunction;
import java.util.stream.Collectors;

public class CategoriesMetric
implements Metric {
    private final Map<String, AtomicLong> values = new HashMap<String, AtomicLong>();
    private final BiFunction<String, Long, MetricLine> lineFactory;

    public CategoriesMetric(BiFunction<String, Long, MetricLine> lineFactory) {
        this.lineFactory = lineFactory;
    }

    public void update(TestResult testResult) {
        if (testResult.isRetry()) {
            return;
        }
        ((List)testResult.getExtraBlock("categories", new ArrayList())).stream().map(Category::getName).forEach(categoryName -> this.values.computeIfAbsent((String)categoryName, s -> new AtomicLong()).incrementAndGet());
    }

    public List<MetricLine> getLines() {
        return this.values.entrySet().stream().map(entry -> this.lineFactory.apply((String)entry.getKey(), ((AtomicLong)entry.getValue()).longValue())).collect(Collectors.toList());
    }
}

