/*
 * Decompiled with CFR 0.152.
 */
package io.qameta.allure.duration;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.qameta.allure.Aggregator;
import io.qameta.allure.CommonJsonAggregator;
import io.qameta.allure.CompositeAggregator;
import io.qameta.allure.Reader;
import io.qameta.allure.context.JacksonContext;
import io.qameta.allure.core.Configuration;
import io.qameta.allure.core.LaunchResults;
import io.qameta.allure.core.ResultsVisitor;
import io.qameta.allure.duration.DurationTrendItem;
import io.qameta.allure.entity.ExecutorInfo;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.Spliterators;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DurationTrendPlugin
extends CompositeAggregator
implements Reader {
    private static final Logger LOGGER = LoggerFactory.getLogger(DurationTrendPlugin.class);
    private static final String DURATION_TREND_BLOCK_NAME = "duration-trend";
    protected static final String JSON_FILE_NAME = "duration-trend.json";

    public DurationTrendPlugin() {
        super(Arrays.asList(new Aggregator[]{new JsonAggregator(), new WidgetAggregator()}));
    }

    public void readResults(Configuration configuration, ResultsVisitor visitor, Path directory) {
        JacksonContext context = (JacksonContext)configuration.requireContext(JacksonContext.class);
        Path historyFile = directory.resolve("history").resolve(JSON_FILE_NAME);
        if (Files.exists(historyFile, new LinkOption[0])) {
            try (InputStream is = Files.newInputStream(historyFile, new OpenOption[0]);){
                ObjectMapper mapper = context.getValue();
                JsonNode jsonNode = mapper.readTree(is);
                List history = this.getStream(jsonNode).map(child -> this.parseItem(historyFile, mapper, (JsonNode)child)).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList());
                visitor.visitExtra(DURATION_TREND_BLOCK_NAME, history);
            }
            catch (IOException e) {
                visitor.error("Could not read duration-trend file " + historyFile, (Exception)e);
            }
        }
    }

    private Stream<JsonNode> getStream(JsonNode jsonNode) {
        return StreamSupport.stream(Spliterators.spliteratorUnknownSize(jsonNode.elements(), 16), false);
    }

    private Optional<DurationTrendItem> parseItem(Path historyFile, ObjectMapper mapper, JsonNode child) {
        try {
            return Optional.ofNullable(mapper.treeToValue((TreeNode)child, DurationTrendItem.class));
        }
        catch (JsonProcessingException e) {
            LOGGER.warn("Could not read {}", (Object)historyFile, (Object)e);
            return Optional.empty();
        }
    }

    static List<DurationTrendItem> getData(List<LaunchResults> launchesResults) {
        DurationTrendItem item = DurationTrendPlugin.createCurrent(launchesResults);
        List<DurationTrendItem> data = DurationTrendPlugin.getHistoryItems(launchesResults);
        return Stream.concat(Stream.of(item), data.stream()).limit(20L).collect(Collectors.toList());
    }

    private static List<DurationTrendItem> getHistoryItems(List<LaunchResults> launchesResults) {
        return launchesResults.stream().map(DurationTrendPlugin::getPreviousTrendData).reduce(new ArrayList(), (first, second) -> {
            first.addAll(second);
            return first;
        });
    }

    private static List<DurationTrendItem> getPreviousTrendData(LaunchResults results) {
        return (List)results.getExtra(DURATION_TREND_BLOCK_NAME, ArrayList::new);
    }

    private static DurationTrendItem createCurrent(List<LaunchResults> launchesResults) {
        DurationTrendItem item = new DurationTrendItem();
        DurationTrendPlugin.extractLatestExecutor(launchesResults).ifPresent(info -> {
            item.setBuildOrder(info.getBuildOrder());
            item.setReportName(info.getReportName());
            item.setReportUrl(info.getReportUrl());
        });
        launchesResults.stream().flatMap(launch -> launch.getResults().stream()).forEach(item::updateTime);
        return item;
    }

    private static Optional<ExecutorInfo> extractLatestExecutor(List<LaunchResults> launches) {
        Comparator<ExecutorInfo> comparator = Comparator.comparing(ExecutorInfo::getBuildOrder, Comparator.nullsFirst(Comparator.naturalOrder()));
        return launches.stream().map(launch -> launch.getExtra("executor")).filter(Optional::isPresent).map(Optional::get).filter(ExecutorInfo.class::isInstance).map(ExecutorInfo.class::cast).max(comparator);
    }

    private static class WidgetAggregator
    extends CommonJsonAggregator {
        WidgetAggregator() {
            super("widgets", DurationTrendPlugin.JSON_FILE_NAME);
        }

        public List<DurationTrendItem> getData(List<LaunchResults> launches) {
            return DurationTrendPlugin.getData(launches);
        }
    }

    private static class JsonAggregator
    extends CommonJsonAggregator {
        JsonAggregator() {
            super("history", DurationTrendPlugin.JSON_FILE_NAME);
        }

        protected List<DurationTrendItem> getData(List<LaunchResults> launches) {
            return DurationTrendPlugin.getData(launches);
        }
    }
}

