/*
 * Decompiled with CFR 0.152.
 */
package io.qameta.allure.history;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.qameta.allure.Aggregator;
import io.qameta.allure.CommonJsonAggregator;
import io.qameta.allure.CompositeAggregator;
import io.qameta.allure.Reader;
import io.qameta.allure.context.JacksonContext;
import io.qameta.allure.core.Configuration;
import io.qameta.allure.core.LaunchResults;
import io.qameta.allure.core.ResultsVisitor;
import io.qameta.allure.entity.ExecutorInfo;
import io.qameta.allure.entity.Statistic;
import io.qameta.allure.entity.TestResult;
import io.qameta.allure.history.HistoryTrendItem;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Spliterators;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HistoryTrendPlugin
extends CompositeAggregator
implements Reader {
    private static final Logger LOGGER = LoggerFactory.getLogger(HistoryTrendPlugin.class);
    public static final String JSON_FILE_NAME = "history-trend.json";
    public static final String HISTORY_TREND_BLOCK_NAME = "history-trend";
    public static final String HISTORY = "history";

    public HistoryTrendPlugin() {
        super(Arrays.asList(new Aggregator[]{new JsonAggregator(), new WidgetAggregator()}));
    }

    public void readResults(Configuration configuration, ResultsVisitor visitor, Path directory) {
        JacksonContext context = (JacksonContext)configuration.requireContext(JacksonContext.class);
        Path historyFile = directory.resolve(HISTORY).resolve(JSON_FILE_NAME);
        if (Files.exists(historyFile, new LinkOption[0])) {
            try (InputStream is = Files.newInputStream(historyFile, new OpenOption[0]);){
                ObjectMapper mapper = context.getValue();
                JsonNode jsonNode = mapper.readTree(is);
                List history = this.getStream(jsonNode).map(child -> this.parseItem(historyFile, mapper, (JsonNode)child)).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList());
                visitor.visitExtra(HISTORY_TREND_BLOCK_NAME, history);
            }
            catch (IOException e) {
                visitor.error("Could not read history-trend file " + historyFile, (Exception)e);
            }
        }
    }

    private Stream<JsonNode> getStream(JsonNode jsonNode) {
        return StreamSupport.stream(Spliterators.spliteratorUnknownSize(jsonNode.elements(), 16), false);
    }

    private Optional<HistoryTrendItem> parseItem(Path historyFile, ObjectMapper mapper, JsonNode child) {
        try {
            if (Objects.nonNull(child.get("total"))) {
                Statistic statistic = (Statistic)mapper.treeToValue((TreeNode)child, Statistic.class);
                return Optional.of(new HistoryTrendItem().setStatistic(statistic));
            }
            return Optional.ofNullable(mapper.treeToValue((TreeNode)child, HistoryTrendItem.class));
        }
        catch (JsonProcessingException e) {
            LOGGER.warn("Could not read {}", (Object)historyFile, (Object)e);
            return Optional.empty();
        }
    }

    static List<HistoryTrendItem> getData(List<LaunchResults> launchesResults) {
        HistoryTrendItem item = HistoryTrendPlugin.createCurrent(launchesResults);
        List<HistoryTrendItem> data = HistoryTrendPlugin.getHistoryItems(launchesResults);
        return Stream.concat(Stream.of(item), data.stream()).limit(20L).collect(Collectors.toList());
    }

    private static HistoryTrendItem createCurrent(List<LaunchResults> launchesResults) {
        Statistic statistic = launchesResults.stream().flatMap(results -> results.getResults().stream()).map(TestResult::getStatus).collect(Statistic::new, Statistic::update, Statistic::merge);
        HistoryTrendItem item = new HistoryTrendItem().setStatistic(statistic);
        HistoryTrendPlugin.extractLatestExecutor(launchesResults).ifPresent(info -> {
            item.setBuildOrder(info.getBuildOrder());
            item.setReportName(info.getReportName());
            item.setReportUrl(info.getReportUrl());
        });
        return item;
    }

    private static List<HistoryTrendItem> getHistoryItems(List<LaunchResults> launchesResults) {
        return launchesResults.stream().map(HistoryTrendPlugin::getPreviousTrendData).reduce(new ArrayList(), (first, second) -> {
            first.addAll(second);
            return first;
        });
    }

    private static List<HistoryTrendItem> getPreviousTrendData(LaunchResults results) {
        return (List)results.getExtra(HISTORY_TREND_BLOCK_NAME, ArrayList::new);
    }

    private static Optional<ExecutorInfo> extractLatestExecutor(List<LaunchResults> launches) {
        Comparator<ExecutorInfo> comparator = Comparator.comparing(ExecutorInfo::getBuildOrder, Comparator.nullsFirst(Comparator.naturalOrder()));
        return launches.stream().map(launch -> launch.getExtra("executor")).filter(Optional::isPresent).map(Optional::get).filter(ExecutorInfo.class::isInstance).map(ExecutorInfo.class::cast).max(comparator);
    }

    private static class WidgetAggregator
    extends CommonJsonAggregator {
        WidgetAggregator() {
            super("widgets", HistoryTrendPlugin.JSON_FILE_NAME);
        }

        public List<HistoryTrendItem> getData(List<LaunchResults> launches) {
            return HistoryTrendPlugin.getData(launches);
        }
    }

    protected static class JsonAggregator
    extends CommonJsonAggregator {
        JsonAggregator() {
            super(HistoryTrendPlugin.HISTORY, HistoryTrendPlugin.JSON_FILE_NAME);
        }

        protected List<HistoryTrendItem> getData(List<LaunchResults> launches) {
            return HistoryTrendPlugin.getData(launches);
        }
    }
}

