/*
 * Decompiled with CFR 0.152.
 */
package io.qameta.allure.jira;

import io.qameta.allure.Aggregator;
import io.qameta.allure.core.Configuration;
import io.qameta.allure.core.LaunchResults;
import io.qameta.allure.entity.ExecutorInfo;
import io.qameta.allure.entity.Link;
import io.qameta.allure.entity.Statistic;
import io.qameta.allure.entity.TestResult;
import io.qameta.allure.jira.JiraLaunch;
import io.qameta.allure.jira.JiraService;
import io.qameta.allure.jira.JiraServiceBuilder;
import io.qameta.allure.jira.JiraTestResult;
import io.qameta.allure.util.PropertyUtils;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JiraExportPlugin
implements Aggregator {
    private static final Logger LOGGER = LoggerFactory.getLogger(JiraExportPlugin.class);
    private static final String EXECUTORS_BLOCK_NAME = "executor";
    private static final String ALLURE_JIRA_ENABLED = "ALLURE_JIRA_ENABLED";
    private static final String ALLURE_JIRA_LAUNCH_ISSUES = "ALLURE_JIRA_LAUNCH_ISSUES";
    private final Supplier<JiraService> jiraServiceSupplier;
    private final boolean enabled;
    private final String issues;

    public JiraExportPlugin() {
        this(PropertyUtils.getProperty((String)ALLURE_JIRA_ENABLED).map(Boolean::parseBoolean).orElse(false), PropertyUtils.getProperty((String)ALLURE_JIRA_LAUNCH_ISSUES).orElse(""), () -> new JiraServiceBuilder().defaults().build());
    }

    public JiraExportPlugin(boolean enabled, String issues, Supplier<JiraService> jiraServiceSupplier) {
        this.jiraServiceSupplier = jiraServiceSupplier;
        this.enabled = enabled;
        this.issues = issues;
    }

    public void aggregate(Configuration configuration, List<LaunchResults> launchesResults, Path outputDirectory) {
        if (this.enabled) {
            JiraService jiraService = this.jiraServiceSupplier.get();
            List<String> issues = JiraExportPlugin.splitByComma(this.issues);
            ExecutorInfo executor = this.getExecutor(launchesResults);
            Statistic statistic = this.getStatistic(launchesResults);
            JiraLaunch launch = this.getJiraLaunch(issues, executor, statistic);
            JiraLaunch created = this.exportLaunchToJira(jiraService, launch);
            this.getTestResults(launchesResults).stream().map(testResult -> this.getJiraTestResult(created, executor, (TestResult)testResult)).filter(Optional::isPresent).map(Optional::get).forEach(testResult -> this.exportTestResultToJira(jiraService, (JiraTestResult)testResult));
        }
    }

    private JiraLaunch getJiraLaunch(List<String> issueKeys, ExecutorInfo executor, Statistic statistic) {
        return new JiraLaunch().setIssueKeys(issueKeys).setName(executor.getBuildName()).setUrl(executor.getReportUrl()).setPassed(Long.valueOf(statistic.getPassed())).setFailed(Long.valueOf(statistic.getFailed())).setBroken(Long.valueOf(statistic.getBroken())).setSkipped(Long.valueOf(statistic.getSkipped())).setUnknown(Long.valueOf(statistic.getUnknown())).setDate(Long.valueOf(System.currentTimeMillis()));
    }

    private Optional<JiraTestResult> getJiraTestResult(JiraLaunch launch, ExecutorInfo executor, TestResult testResult) {
        List issues = testResult.getLinks().stream().filter(this::isIssueLink).map(Link::getName).collect(Collectors.toList());
        if (issues.isEmpty()) {
            return Optional.empty();
        }
        JiraTestResult jiraTestResult = new JiraTestResult().setIssueKeys(issues).setName(testResult.getName()).setUrl(this.getJiraTestResultUrl(executor.getReportUrl(), testResult.getUid())).setStatus(testResult.getStatus().toString()).setDate(testResult.getTime().getStop()).setLaunchId(Integer.valueOf(launch.getId()));
        return Optional.of(jiraTestResult);
    }

    private List<TestResult> getTestResults(List<LaunchResults> launchesResults) {
        return launchesResults.stream().map(LaunchResults::getAllResults).flatMap(Collection::stream).collect(Collectors.toList());
    }

    private ExecutorInfo getExecutor(List<LaunchResults> launchesResults) {
        return launchesResults.stream().map(launchResults -> launchResults.getExtra(EXECUTORS_BLOCK_NAME)).filter(Optional::isPresent).map(Optional::get).filter(ExecutorInfo.class::isInstance).map(ExecutorInfo.class::cast).findFirst().orElse(new ExecutorInfo());
    }

    private Statistic getStatistic(List<LaunchResults> launchesResults) {
        Statistic statistic = new Statistic();
        launchesResults.stream().map(LaunchResults::getAllResults).flatMap(Collection::stream).forEach(arg_0 -> ((Statistic)statistic).update(arg_0));
        return statistic;
    }

    private JiraLaunch exportLaunchToJira(JiraService jiraService, JiraLaunch launch) {
        try {
            JiraLaunch created = jiraService.createJiraLaunch(launch);
            LOGGER.info(String.format("Allure launch '%s' synced with issues '%s' successfully", created.getId(), created.getIssueKeys()));
            return created;
        }
        catch (Throwable e) {
            LOGGER.error(String.format("Allure launch sync with issue '%s' error", launch.getIssueKeys()), e);
            throw e;
        }
    }

    private void exportTestResultToJira(JiraService jiraService, JiraTestResult testResult) {
        try {
            JiraTestResult created = jiraService.createTestResult(testResult);
            LOGGER.info(String.format("Allure test result '%s' synced with issue '%s' successfully", created.getId(), created.getIssueKeys()));
        }
        catch (Throwable e) {
            LOGGER.error(String.format("Allure test result sync with issue '%s' failed", testResult.getIssueKeys()), e);
            throw e;
        }
    }

    private String getJiraTestResultUrl(String reportUrl, String uuid) {
        return Optional.ofNullable(reportUrl).map(url -> url.endsWith("index.html") ? "%s#testresult/%s" : "%s/#testresult/%s").map(pattern -> String.format(pattern, reportUrl, uuid)).orElse(null);
    }

    private boolean isIssueLink(Link link) {
        return "issue".equals(link.getType());
    }

    private static List<String> splitByComma(String value) {
        return Arrays.asList(value.split(","));
    }
}

