/*
 * Decompiled with CFR 0.152.
 */
package ru.qatools.properties.converters;

import java.lang.reflect.Array;
import ru.qatools.properties.converters.Converter;
import ru.qatools.properties.converters.StringSplitter;

public class ArrayConverter
implements Converter {
    private Converter childConverter;
    private Class childType;
    private StringSplitter stringSplitter;

    public ArrayConverter(Converter childConverter, Class childType, StringSplitter stringSplitter) {
        this.childConverter = childConverter;
        this.childType = childType;
        this.stringSplitter = stringSplitter;
    }

    public Object convert(String from) throws Exception {
        String[] children = this.stringSplitter.split(from);
        if (children.length == 1 && children[0].trim().isEmpty()) {
            return Array.newInstance(this.childType, 0);
        }
        Object result = Array.newInstance(this.childType, children.length);
        for (int i = 0; i < children.length; ++i) {
            Array.set(result, i, this.childConverter.convert(children[i]));
        }
        return result;
    }
}

