/*
 * Decompiled with CFR 0.152.
 */
package io.qameta.allure.xctest;

import io.qameta.allure.Reader;
import io.qameta.allure.core.Configuration;
import io.qameta.allure.core.ResultsVisitor;
import io.qameta.allure.entity.LabelName;
import io.qameta.allure.entity.Status;
import io.qameta.allure.entity.Step;
import io.qameta.allure.entity.TestResult;
import io.qameta.allure.entity.Timeable;
import io.qameta.allure.xctest.ResultsUtils;
import java.io.File;
import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.DateTimeException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import xmlwise.Plist;
import xmlwise.XmlParseException;

public class XcTestPlugin
implements Reader {
    private static final Logger LOGGER = LoggerFactory.getLogger(XcTestPlugin.class);
    public static final String XCTEST_RESULTS_FORMAT = "xctest";
    private static final String TESTABLE_SUMMARIES = "TestableSummaries";
    private static final String TESTS = "Tests";
    private static final String SUB_TESTS = "Subtests";
    private static final String TITLE = "Title";
    private static final String SUB_ACTIVITIES = "SubActivities";
    private static final String ACTIVITY_SUMMARIES = "ActivitySummaries";
    private static final String HAS_SCREENSHOT = "HasScreenshotData";

    public void readResults(Configuration configuration, ResultsVisitor visitor, Path directory) {
        List<Path> testSummaries = XcTestPlugin.listSummaries(directory);
        testSummaries.forEach(summaryPath -> this.readSummaries(directory, (Path)summaryPath, visitor));
    }

    private void readSummaries(Path directory, Path testSummariesPath, ResultsVisitor visitor) {
        try {
            LOGGER.info("Parse file {}", (Object)testSummariesPath);
            Map loaded = Plist.load((File)testSummariesPath.toFile());
            List<Object> summaries = this.asList(loaded.getOrDefault(TESTABLE_SUMMARIES, Collections.emptyList()));
            summaries.forEach(summary -> this.parseSummary(directory, summary, visitor));
        }
        catch (IOException | XmlParseException e) {
            LOGGER.error("Could not parse file {}: {}", (Object)testSummariesPath, (Object)e);
        }
    }

    private void parseSummary(Path directory, Object summary, ResultsVisitor visitor) {
        Map<String, Object> props = this.asMap(summary);
        String name = ResultsUtils.getTestName(props);
        List<Object> tests = this.asList(props.getOrDefault(TESTS, Collections.emptyList()));
        tests.forEach(test -> this.parseTestSuite(name, test, directory, visitor));
    }

    private void parseTestSuite(String parentName, Object testSuite, Path directory, ResultsVisitor visitor) {
        Map<String, Object> props = this.asMap(testSuite);
        if (ResultsUtils.isTest(props)) {
            this.parseTest(parentName, testSuite, directory, visitor);
            return;
        }
        List<Object> subTests = this.asList(props.getOrDefault(SUB_TESTS, Collections.emptyList()));
        subTests.forEach(subTest -> this.parseTestSuite(ResultsUtils.getTestName(props), subTest, directory, visitor));
    }

    private void parseTest(String suiteName, Object test, Path directory, ResultsVisitor visitor) {
        Map<String, Object> props = this.asMap(test);
        TestResult result = ResultsUtils.getTestResult(props);
        result.addLabelIfNotExists(LabelName.RESULT_FORMAT, XCTEST_RESULTS_FORMAT);
        result.addLabelIfNotExists(LabelName.SUITE, suiteName);
        this.asList(props.getOrDefault(ACTIVITY_SUMMARIES, Collections.emptyList())).forEach(activity -> this.parseStep(directory, result, activity, visitor));
        Optional<Step> lastFailedStep = result.getTestStage().getSteps().stream().filter(s -> !s.getStatus().equals((Object)Status.PASSED)).sorted((a, b) -> -1).findFirst();
        lastFailedStep.map(Step::getStatusMessage).ifPresent(arg_0 -> ((TestResult)result).setStatusMessage(arg_0));
        lastFailedStep.map(Step::getStatusTrace).ifPresent(arg_0 -> ((TestResult)result).setStatusTrace(arg_0));
        visitor.visitTestResult(result);
    }

    private void parseStep(Path directory, Object parent, Object activity, ResultsVisitor visitor) {
        Map<String, Object> props = this.asMap(activity);
        String activityTitle = (String)props.get(TITLE);
        if (activityTitle.startsWith("Start Test at")) {
            XcTestPlugin.getStartTime(activityTitle).ifPresent(start -> {
                Timeable withTime = (Timeable)parent;
                long duration = withTime.getTime().getDuration();
                withTime.getTime().setStart(start);
                withTime.getTime().setStop(Long.valueOf(start + duration));
            });
            return;
        }
        Step step = ResultsUtils.getStep(props);
        if (activityTitle.startsWith("Assertion Failure:")) {
            step.setStatusMessage(activityTitle);
            step.setStatus(Status.FAILED);
        }
        if (props.containsKey(HAS_SCREENSHOT)) {
            this.addAttachment(directory, visitor, props, step);
        }
        if (parent instanceof TestResult) {
            ((TestResult)parent).getTestStage().getSteps().add(step);
        }
        if (parent instanceof Step) {
            ((Step)parent).getSteps().add(step);
        }
        this.asList(props.getOrDefault(SUB_ACTIVITIES, Collections.emptyList())).forEach(subActivity -> this.parseStep(directory, step, subActivity, visitor));
        Optional<Step> lastFailedStep = step.getSteps().stream().filter(s -> !s.getStatus().equals((Object)Status.PASSED)).sorted((a, b) -> -1).findFirst();
        lastFailedStep.map(Step::getStatus).ifPresent(arg_0 -> ((Step)step).setStatus(arg_0));
        lastFailedStep.map(Step::getStatusMessage).ifPresent(arg_0 -> ((Step)step).setStatusMessage(arg_0));
        lastFailedStep.map(Step::getStatusTrace).ifPresent(arg_0 -> ((Step)step).setStatusTrace(arg_0));
    }

    private void addAttachment(Path directory, ResultsVisitor visitor, Map<String, Object> props, Step step) {
        String uuid = props.get("UUID").toString();
        Path attachments = directory.resolve("Attachments");
        Stream.of("jpg", "png").map(ext -> attachments.resolve(String.format("Screenshot_%s.%s", uuid, ext))).filter(x$0 -> Files.exists(x$0, new LinkOption[0])).map(arg_0 -> ((ResultsVisitor)visitor).visitAttachmentFile(arg_0)).forEach(step.getAttachments()::add);
    }

    private List<Object> asList(Object object) {
        return (List)List.class.cast(object);
    }

    private Map<String, Object> asMap(Object object) {
        return (Map)Map.class.cast(object);
    }

    private static List<Path> listSummaries(Path directory) {
        ArrayList<Path> result = new ArrayList<Path>();
        if (!Files.isDirectory(directory, new LinkOption[0])) {
            return result;
        }
        try (DirectoryStream<Path> directoryStream = Files.newDirectoryStream(directory, "*.plist");){
            for (Path path : directoryStream) {
                if (Files.isDirectory(path, new LinkOption[0])) continue;
                result.add(path);
            }
        }
        catch (IOException e) {
            LOGGER.error("Could not read data from {}: {}", (Object)directory, (Object)e);
        }
        return result;
    }

    private static Optional<Long> getStartTime(String stepName) {
        try {
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSSX", Locale.US);
            Date date = dateFormat.parse(stepName.substring(14));
            return Optional.of(date.getTime());
        }
        catch (ParseException | DateTimeException e) {
            return Optional.empty();
        }
    }
}

