/*
 * Decompiled with CFR 0.152.
 */
package io.qameta.allure.history;

import com.fasterxml.jackson.core.type.TypeReference;
import io.qameta.allure.Aggregator;
import io.qameta.allure.Reader;
import io.qameta.allure.context.JacksonContext;
import io.qameta.allure.core.Configuration;
import io.qameta.allure.core.LaunchResults;
import io.qameta.allure.core.ResultsVisitor;
import io.qameta.allure.entity.ExecutorInfo;
import io.qameta.allure.entity.Statistic;
import io.qameta.allure.entity.Status;
import io.qameta.allure.entity.Statusable;
import io.qameta.allure.entity.TestResult;
import io.qameta.allure.history.HistoryData;
import io.qameta.allure.history.HistoryItem;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class HistoryPlugin
implements Reader,
Aggregator {
    private static final String HISTORY_BLOCK_NAME = "history";
    private static final String HISTORY_FILE_NAME = "history.json";
    private static final TypeReference<Map<String, HistoryData>> HISTORY_TYPE = new TypeReference<Map<String, HistoryData>>(){};

    public void readResults(Configuration configuration, ResultsVisitor visitor, Path directory) {
        JacksonContext context = (JacksonContext)configuration.requireContext(JacksonContext.class);
        Path historyFile = directory.resolve(HISTORY_BLOCK_NAME).resolve(HISTORY_FILE_NAME);
        if (Files.exists(historyFile, new LinkOption[0])) {
            try (InputStream is = Files.newInputStream(historyFile, new OpenOption[0]);){
                Map history = (Map)context.getValue().readValue(is, HISTORY_TYPE);
                visitor.visitExtra(HISTORY_BLOCK_NAME, (Object)history);
            }
            catch (IOException e) {
                visitor.error("Could not read history file " + historyFile, (Exception)e);
            }
        }
    }

    public void aggregate(Configuration configuration, List<LaunchResults> launchesResults, Path outputDirectory) throws IOException {
        JacksonContext context = (JacksonContext)configuration.requireContext(JacksonContext.class);
        Path historyFolder = Files.createDirectories(outputDirectory.resolve(HISTORY_BLOCK_NAME), new FileAttribute[0]);
        Path historyFile = historyFolder.resolve(HISTORY_FILE_NAME);
        try (OutputStream os = Files.newOutputStream(historyFile, new OpenOption[0]);){
            context.getValue().writeValue(os, this.getData(launchesResults));
        }
    }

    private boolean isNewFailed(List<HistoryItem> histories) {
        List statuses = histories.stream().sorted(HistoryItem.comparingByTime()).map(HistoryItem::getStatus).collect(Collectors.toList());
        return statuses.size() > 1 && statuses.get(0) == Status.FAILED && statuses.get(1) == Status.PASSED;
    }

    private boolean isFlaky(List<HistoryItem> histories) {
        if (histories.size() > 1 && histories.get((int)0).status == Status.FAILED) {
            List statuses = histories.subList(1, histories.size()).stream().sorted(HistoryItem.comparingByTime()).map(HistoryItem::getStatus).collect(Collectors.toList());
            return statuses.indexOf(Status.PASSED) < statuses.lastIndexOf(Status.FAILED) && statuses.indexOf(Status.PASSED) != -1;
        }
        return false;
    }

    protected Map<String, HistoryData> getData(List<LaunchResults> launches) {
        return launches.stream().map(launch -> {
            ExecutorInfo executorInfo = (ExecutorInfo)launch.getExtra("executor", ExecutorInfo::new);
            Map history = (Map)launch.getExtra(HISTORY_BLOCK_NAME, HashMap::new);
            launch.getResults().stream().filter(result -> Objects.nonNull(result.getHistoryId())).forEach(result -> this.updateHistory(history, (TestResult)result, executorInfo));
            return history;
        }).reduce(new HashMap(), (a, b) -> {
            a.putAll(b);
            return a;
        });
    }

    private void updateHistory(Map<String, HistoryData> history, TestResult result, ExecutorInfo info) {
        HistoryData data = history.computeIfAbsent(result.getHistoryId(), id -> new HistoryData().setStatistic(new Statistic()));
        data.getStatistic().update((Statusable)result);
        if (!data.getItems().isEmpty()) {
            result.addExtraBlock(HISTORY_BLOCK_NAME, (Object)HistoryPlugin.copy(data));
        }
        HistoryItem newItem = new HistoryItem().setUid(result.getUid()).setStatus(result.getStatus()).setStatusDetails(result.getStatusMessage()).setTime(result.getTime());
        if (Objects.nonNull(info.getReportUrl())) {
            newItem.setReportUrl(HistoryPlugin.createReportUrl(info.getReportUrl(), result.getUid()));
        }
        List<HistoryItem> newItems = Stream.concat(Stream.of(newItem), data.getItems().stream()).limit(5L).collect(Collectors.toList());
        result.setNewFailed(this.isNewFailed(newItems));
        result.setFlaky(this.isFlaky(newItems));
        data.setItems(newItems);
    }

    private static HistoryData copy(HistoryData other) {
        Statistic statistic = new Statistic();
        statistic.merge(other.getStatistic());
        ArrayList<HistoryItem> items = new ArrayList<HistoryItem>(other.getItems());
        return new HistoryData().setStatistic(statistic).setItems(items);
    }

    private static String createReportUrl(String reportUrl, String uuid) {
        String pattern = reportUrl.endsWith("index.html") ? "%s#testresult/%s" : "%s/#testresult/%s";
        return String.format(pattern, reportUrl, uuid);
    }
}

