/*
 * Decompiled with CFR 0.152.
 */
package io.qameta.allure.plugin;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import io.qameta.allure.Extension;
import io.qameta.allure.PluginConfiguration;
import io.qameta.allure.core.Plugin;
import io.qameta.allure.plugin.DefaultPlugin;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultPluginLoader {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultPluginLoader.class);

    public Optional<Plugin> loadPlugin(ClassLoader parent, Path pluginDirectory) {
        Optional<PluginConfiguration> pluginConfiguration = this.loadPluginConfiguration(pluginDirectory);
        if (pluginConfiguration.isPresent()) {
            PluginConfiguration configuration = pluginConfiguration.get();
            if (!configuration.getExtensions().isEmpty()) {
                ClassLoader classLoader = this.createClassLoader(parent, pluginDirectory);
                List<Extension> extensions = configuration.getExtensions().stream().map(name -> this.load(classLoader, (String)name)).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList());
                return Optional.of(new DefaultPlugin(configuration, extensions, pluginDirectory));
            }
            return Optional.of(new DefaultPlugin(configuration, Collections.emptyList(), pluginDirectory));
        }
        return Optional.empty();
    }

    private Optional<Extension> load(ClassLoader classLoader, String name) {
        try {
            Extension loaded = (Extension)classLoader.loadClass(name).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            return Optional.of(loaded);
        }
        catch (Exception e) {
            LOGGER.error("Could not load extension class {}: {}", (Object)name, (Object)e);
            return Optional.empty();
        }
    }

    private Optional<PluginConfiguration> loadPluginConfiguration(Path pluginDirectory) {
        Optional<PluginConfiguration> optional;
        block9: {
            Path configuration = pluginDirectory.resolve("allure-plugin.yml");
            if (Files.notExists(configuration, new LinkOption[0])) {
                LOGGER.warn("Invalid plugin directory " + pluginDirectory);
                return Optional.empty();
            }
            ObjectMapper mapper = new ObjectMapper((JsonFactory)new YAMLFactory());
            InputStream is = Files.newInputStream(configuration, new OpenOption[0]);
            try {
                optional = Optional.of((PluginConfiguration)mapper.readValue(is, PluginConfiguration.class));
                if (is == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    LOGGER.error("Could not read plugin configuration", (Throwable)e);
                    return Optional.empty();
                }
            }
            is.close();
        }
        return optional;
    }

    private ClassLoader createClassLoader(ClassLoader parent, Path pluginDirectory) {
        Path lib = pluginDirectory.resolve("lib");
        URL[] urls = (URL[])Stream.of(pluginDirectory, lib).filter(x$0 -> Files.isDirectory(x$0, new LinkOption[0])).flatMap(dir -> this.jarsInDirectory((Path)dir).stream()).toArray(URL[]::new);
        return new URLClassLoader(urls, parent);
    }

    private List<URL> jarsInDirectory(Path directory) {
        List<URL> list;
        block8: {
            DirectoryStream.Filter<Path> pathFilter = entry -> Files.isRegularFile(entry, new LinkOption[0]) && entry.toString().endsWith(".jar");
            DirectoryStream<Path> stream = Files.newDirectoryStream(directory, pathFilter);
            try {
                list = StreamSupport.stream(stream.spliterator(), false).filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).map(this::toUrlSafe).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList());
                if (stream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    LOGGER.error("Could not load plugin", (Throwable)e);
                    return Collections.emptyList();
                }
            }
            stream.close();
        }
        return list;
    }

    private Optional<URL> toUrlSafe(Path path) {
        try {
            return Optional.of(path.toUri().toURL());
        }
        catch (MalformedURLException e) {
            LOGGER.error("Could not load {}: {}", (Object)path, (Object)e);
            return Optional.empty();
        }
    }
}

