/*
 * Decompiled with CFR 0.152.
 */
package io.qameta.allure.behaviors;

import io.qameta.allure.Aggregator2;
import io.qameta.allure.CommonCsvExportAggregator2;
import io.qameta.allure.CommonJsonAggregator2;
import io.qameta.allure.CompositeAggregator2;
import io.qameta.allure.core.LaunchResults;
import io.qameta.allure.csv.CsvExportBehavior;
import io.qameta.allure.entity.LabelName;
import io.qameta.allure.entity.Statistic;
import io.qameta.allure.entity.TestResult;
import io.qameta.allure.tree.TestResultTree;
import io.qameta.allure.tree.TestResultTreeGroup;
import io.qameta.allure.tree.Tree;
import io.qameta.allure.tree.TreeUtils;
import io.qameta.allure.tree.TreeWidgetData;
import io.qameta.allure.tree.TreeWidgetItem;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

public class BehaviorsPlugin
extends CompositeAggregator2 {
    protected static final String BEHAVIORS = "behaviors";
    protected static final String JSON_FILE_NAME = "behaviors.json";
    protected static final String CSV_FILE_NAME = "behaviors.csv";
    static final LabelName[] LABEL_NAMES = new LabelName[]{LabelName.EPIC, LabelName.FEATURE, LabelName.STORY};

    public BehaviorsPlugin() {
        super(Arrays.asList(new Aggregator2[]{new JsonAggregator(), new CsvExportAggregator(), new WidgetAggregator()}));
    }

    static Tree<TestResult> getData(List<LaunchResults> launchResults) {
        TestResultTree behaviors = new TestResultTree(BEHAVIORS, testResult -> TreeUtils.groupByLabels((TestResult)testResult, (LabelName[])LABEL_NAMES));
        launchResults.stream().map(LaunchResults::getResults).flatMap(Collection::stream).sorted(TestResult.comparingByTimeAsc()).forEach(arg_0 -> ((Tree)behaviors).add(arg_0));
        return behaviors;
    }

    private static boolean isNotEmpty(List<String> strings) {
        return !Objects.isNull(strings) && !strings.isEmpty();
    }

    private static class JsonAggregator
    extends CommonJsonAggregator2 {
        JsonAggregator() {
            super(BehaviorsPlugin.JSON_FILE_NAME);
        }

        protected Tree<TestResult> getData(List<LaunchResults> launches) {
            return BehaviorsPlugin.getData(launches);
        }
    }

    private static class CsvExportAggregator
    extends CommonCsvExportAggregator2<CsvExportBehavior> {
        CsvExportAggregator() {
            super(BehaviorsPlugin.CSV_FILE_NAME, CsvExportBehavior.class);
        }

        protected List<CsvExportBehavior> getData(List<LaunchResults> launchesResults) {
            ArrayList<CsvExportBehavior> exportBehaviors = new ArrayList<CsvExportBehavior>();
            launchesResults.stream().flatMap(launch -> launch.getResults().stream()).forEach(result -> {
                HashMap<LabelName, List<String>> epicFeatureStoryMap = new HashMap<LabelName, List<String>>();
                Arrays.asList(LABEL_NAMES).forEach(label -> epicFeatureStoryMap.put((LabelName)label, result.findAllLabels(label)));
                this.addTestResult((List<CsvExportBehavior>)exportBehaviors, (TestResult)result, (Map<LabelName, List<String>>)epicFeatureStoryMap);
            });
            return exportBehaviors;
        }

        private void addTestResult(List<CsvExportBehavior> exportBehaviors, TestResult result, Map<LabelName, List<String>> epicFeatureStoryMap) {
            if (epicFeatureStoryMap.isEmpty()) {
                this.addTestResultWithLabels(exportBehaviors, result, null, null, null);
            } else {
                this.addTestResultWithEpic(exportBehaviors, result, epicFeatureStoryMap);
            }
        }

        private void addTestResultWithEpic(List<CsvExportBehavior> exportBehaviors, TestResult result, Map<LabelName, List<String>> epicFeatureStoryMap) {
            if (BehaviorsPlugin.isNotEmpty(epicFeatureStoryMap.get(LabelName.EPIC))) {
                epicFeatureStoryMap.get(LabelName.EPIC).forEach(epic -> this.addTestResultWithFeature(exportBehaviors, result, epicFeatureStoryMap, (String)epic));
            } else {
                this.addTestResultWithFeature(exportBehaviors, result, epicFeatureStoryMap, null);
            }
        }

        private void addTestResultWithFeature(List<CsvExportBehavior> exportBehaviors, TestResult result, Map<LabelName, List<String>> epicFeatureStoryMap, String epic) {
            if (BehaviorsPlugin.isNotEmpty(epicFeatureStoryMap.get(LabelName.FEATURE))) {
                epicFeatureStoryMap.get(LabelName.FEATURE).forEach(feature -> this.addTestResultWithStories(exportBehaviors, result, epicFeatureStoryMap, epic, (String)feature));
            } else {
                this.addTestResultWithStories(exportBehaviors, result, epicFeatureStoryMap, epic, null);
            }
        }

        private void addTestResultWithStories(List<CsvExportBehavior> exportBehaviors, TestResult result, Map<LabelName, List<String>> epicFeatureStoryMap, String epic, String feature) {
            if (BehaviorsPlugin.isNotEmpty(epicFeatureStoryMap.get(LabelName.STORY))) {
                epicFeatureStoryMap.get(LabelName.STORY).forEach(story -> this.addTestResultWithLabels(exportBehaviors, result, epic, feature, (String)story));
            } else {
                this.addTestResultWithLabels(exportBehaviors, result, epic, feature, null);
            }
        }

        private void addTestResultWithLabels(List<CsvExportBehavior> exportBehaviors, TestResult result, String epic, String feature, String story) {
            Optional<CsvExportBehavior> behavior = exportBehaviors.stream().filter(exportBehavior -> exportBehavior.isPassed(epic, feature, story)).findFirst();
            if (behavior.isPresent()) {
                behavior.get().addTestResult(result);
            } else {
                CsvExportBehavior exportBehavior2 = new CsvExportBehavior(epic, feature, story);
                exportBehavior2.addTestResult(result);
                exportBehaviors.add(exportBehavior2);
            }
        }
    }

    protected static class WidgetAggregator
    extends CommonJsonAggregator2 {
        WidgetAggregator() {
            super("widgets", BehaviorsPlugin.JSON_FILE_NAME);
        }

        public TreeWidgetData getData(List<LaunchResults> launches) {
            Tree<TestResult> data = BehaviorsPlugin.getData(launches);
            List items = data.getChildren().stream().filter(TestResultTreeGroup.class::isInstance).map(TestResultTreeGroup.class::cast).map(WidgetAggregator::toWidgetItem).sorted(Comparator.comparing(TreeWidgetItem::getStatistic, Statistic.comparator()).reversed()).limit(10L).collect(Collectors.toList());
            return new TreeWidgetData().setItems(items).setTotal((long)data.getChildren().size());
        }

        private static TreeWidgetItem toWidgetItem(TestResultTreeGroup group) {
            return new TreeWidgetItem().setUid(group.getUid()).setName(group.getName()).setStatistic(TreeUtils.calculateStatisticByChildren((TestResultTreeGroup)group));
        }
    }
}

