/*
 * Decompiled with CFR 0.152.
 */
package io.qameta.allure;

import io.qameta.allure.DefaultLaunchResults;
import io.qameta.allure.context.RandomUidContext;
import io.qameta.allure.core.Configuration;
import io.qameta.allure.core.LaunchResults;
import io.qameta.allure.core.ResultsVisitor;
import io.qameta.allure.entity.Attachment;
import io.qameta.allure.entity.TestResult;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.io.FilenameUtils;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.mime.MimeTypes;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultResultsVisitor
implements ResultsVisitor {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultResultsVisitor.class);
    public static final String WILDCARD = "*/*";
    private final Configuration configuration;
    private final Map<Path, Attachment> attachments;
    private final Set<TestResult> results;
    private final Map<String, Object> extra;

    public DefaultResultsVisitor(Configuration configuration) {
        this.configuration = configuration;
        this.results = ConcurrentHashMap.newKeySet();
        this.attachments = new ConcurrentHashMap<Path, Attachment>();
        this.extra = new ConcurrentHashMap<String, Object>();
    }

    public Attachment visitAttachmentFile(Path attachmentFile) {
        RandomUidContext context = (RandomUidContext)this.configuration.requireContext(RandomUidContext.class);
        return this.attachments.computeIfAbsent(attachmentFile, file -> {
            String uid = (String)context.getValue().get();
            String realType = DefaultResultsVisitor.probeContentType(file);
            String extension = Optional.of(FilenameUtils.getExtension((String)file.toString())).filter(s -> !s.isEmpty()).map(s -> "." + s).orElseGet(() -> DefaultResultsVisitor.getExtensionByMimeType(realType));
            String source = uid + (extension.isEmpty() ? "" : extension);
            Long size = DefaultResultsVisitor.getFileSizeSafe(file);
            return new Attachment().setUid(uid).setName(file.getFileName().toString()).setSource(source).setType(realType).setSize(size);
        });
    }

    public void visitTestResult(TestResult result) {
        this.results.add(result);
    }

    public void visitExtra(String name, Object object) {
        this.extra.put(name, object);
    }

    public void error(String message, Exception e) {
    }

    public void error(String message) {
    }

    public LaunchResults getLaunchResults() {
        return new DefaultLaunchResults(Collections.unmodifiableSet(this.results), Collections.unmodifiableMap(this.attachments), Collections.unmodifiableMap(this.extra));
    }

    private static String getExtensionByMimeType(String type) {
        try {
            return MimeTypes.getDefaultMimeTypes().forName(type).getExtension();
        }
        catch (Exception e) {
            LOGGER.warn("Can't detect extension for MIME-type {}", (Object)type, (Object)e);
            return "";
        }
    }

    public static String probeContentType(Path path) {
        String string;
        block8: {
            InputStream stream = Files.newInputStream(path, new OpenOption[0]);
            try {
                string = DefaultResultsVisitor.probeContentType(stream, Objects.toString(path.getFileName()));
                if (stream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    LOGGER.warn("Couldn't detect the media type of attachment {}", (Object)path, (Object)e);
                    return WILDCARD;
                }
            }
            stream.close();
        }
        return string;
    }

    public static String probeContentType(InputStream is, String name) {
        String string;
        BufferedInputStream stream = new BufferedInputStream(is);
        try {
            Metadata metadata = new Metadata();
            metadata.set("resourceName", name);
            string = MimeTypes.getDefaultMimeTypes().detect((InputStream)stream, metadata).toString();
        }
        catch (Throwable throwable) {
            try {
                try {
                    ((InputStream)stream).close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                LOGGER.warn("Couldn't detect the media type of attachment {}", (Object)name, (Object)e);
                return WILDCARD;
            }
        }
        ((InputStream)stream).close();
        return string;
    }

    private static Long getFileSizeSafe(Path path) {
        try {
            return Files.size(path);
        }
        catch (IOException e) {
            LOGGER.warn("Could not get the size of file {}", (Object)path, (Object)e);
            return null;
        }
    }
}

