/*
 * Decompiled with CFR 0.152.
 */
package io.qameta.allure;

import com.opencsv.bean.BeanField;
import com.opencsv.bean.ColumnPositionMappingStrategy;
import com.opencsv.bean.CsvBindByName;
import com.opencsv.bean.StatefulBeanToCsv;
import com.opencsv.bean.StatefulBeanToCsvBuilder;
import com.opencsv.exceptions.CsvDataTypeMismatchException;
import com.opencsv.exceptions.CsvRequiredFieldEmptyException;
import io.qameta.allure.Aggregator2;
import io.qameta.allure.Constants;
import io.qameta.allure.ReportStorage;
import io.qameta.allure.core.Configuration;
import io.qameta.allure.core.LaunchResults;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UncheckedIOException;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.List;
import org.apache.commons.lang3.reflect.FieldUtils;

public abstract class CommonCsvExportAggregator2<T>
implements Aggregator2 {
    private final String fileName;
    private final Class<T> type;

    public CommonCsvExportAggregator2(String fileName, Class<T> type) {
        this.fileName = fileName;
        this.type = type;
    }

    @Override
    public void aggregate(Configuration configuration, List<LaunchResults> launchesResults, ReportStorage storage) {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        try (OutputStreamWriter writer = new OutputStreamWriter((OutputStream)bos, StandardCharsets.UTF_8);){
            StatefulBeanToCsvBuilder builder = new StatefulBeanToCsvBuilder((Writer)writer);
            CustomMappingStrategy mappingStrategy = new CustomMappingStrategy();
            mappingStrategy.setType(this.type);
            StatefulBeanToCsv beanWriter = builder.withMappingStrategy(mappingStrategy).build();
            try {
                beanWriter.write(this.getData(launchesResults));
            }
            catch (CsvDataTypeMismatchException | CsvRequiredFieldEmptyException e) {
                throw new IOException(e);
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        storage.addDataBinary(Constants.dataPath(this.fileName), bos.toByteArray());
    }

    protected abstract List<T> getData(List<LaunchResults> var1);

    private static final class CustomMappingStrategy<T>
    extends ColumnPositionMappingStrategy<T> {
        private CustomMappingStrategy() {
        }

        public String[] generateHeader(T bean) throws CsvRequiredFieldEmptyException {
            super.setColumnMapping(new String[FieldUtils.getAllFields(bean.getClass()).length]);
            int numColumns = this.findMaxFieldIndex();
            if (!this.isAnnotationDriven() || numColumns == -1) {
                return super.generateHeader(bean);
            }
            String[] header = new String[numColumns + 1];
            for (int i = 0; i <= numColumns; ++i) {
                String columnHeaderName;
                BeanField beanField = this.findField(i);
                header[i] = columnHeaderName = this.extractHeaderName(beanField);
            }
            return header;
        }

        private String extractHeaderName(BeanField<T> beanField) {
            if (beanField == null || beanField.getField() == null || ((CsvBindByName[])beanField.getField().getDeclaredAnnotationsByType(CsvBindByName.class)).length == 0) {
                return "";
            }
            CsvBindByName bindByNameAnnotation = ((CsvBindByName[])beanField.getField().getDeclaredAnnotationsByType(CsvBindByName.class))[0];
            return bindByNameAnnotation.column();
        }
    }
}

