/*
 * Decompiled with CFR 0.152.
 */
package io.qameta.allure;

import io.qameta.allure.Context;
import io.qameta.allure.Extension;
import io.qameta.allure.core.Configuration;
import io.qameta.allure.core.Plugin;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.UUID;

public class DefaultConfiguration
implements Configuration {
    private static final String UNDEFINED = "Undefined";
    private final List<Extension> extensions;
    private final List<Plugin> plugins;
    private final String uuid;
    private final String version;
    private final String reportName;
    private final String reportLanguage;

    @Deprecated
    public DefaultConfiguration(List<Extension> extensions, List<Plugin> plugins) {
        this(UUID.randomUUID().toString(), UNDEFINED, null, null, extensions, plugins);
    }

    @Deprecated
    public DefaultConfiguration(String reportName, List<Extension> extensions, List<Plugin> plugins) {
        this(UUID.randomUUID().toString(), UNDEFINED, reportName, null, extensions, plugins);
    }

    DefaultConfiguration(String uuid, String version, String reportName, String reportLanguage, List<Extension> extensions, List<Plugin> plugins) {
        this.reportName = reportName;
        this.reportLanguage = reportLanguage;
        this.extensions = extensions;
        this.plugins = plugins;
        this.uuid = uuid;
        this.version = version;
    }

    public String getUuid() {
        return this.uuid;
    }

    public String getVersion() {
        return this.version;
    }

    public String getReportLanguage() {
        return this.reportLanguage;
    }

    public String getReportName() {
        return this.reportName;
    }

    public List<Plugin> getPlugins() {
        return Collections.unmodifiableList(this.plugins);
    }

    public List<Extension> getExtensions() {
        return Collections.unmodifiableList(this.extensions);
    }

    public <S, T extends Context<S>> Optional<T> getContext(Class<T> contextType) {
        return this.getExtensions(contextType).stream().findFirst();
    }
}

