/*
 * Decompiled with CFR 0.152.
 */
package io.qameta.allure.allure2;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.json.JsonMapper;
import io.qameta.allure.Reader;
import io.qameta.allure.context.RandomUidContext;
import io.qameta.allure.core.Configuration;
import io.qameta.allure.core.ResultsVisitor;
import io.qameta.allure.entity.LabelName;
import io.qameta.allure.entity.Parameter;
import io.qameta.allure.entity.StageResult;
import io.qameta.allure.entity.Status;
import io.qameta.allure.entity.Step;
import io.qameta.allure.entity.Time;
import io.qameta.allure.model.Attachment;
import io.qameta.allure.model.FixtureResult;
import io.qameta.allure.model.Label;
import io.qameta.allure.model.Link;
import io.qameta.allure.model.Parameter;
import io.qameta.allure.model.StepResult;
import io.qameta.allure.model.TestResult;
import io.qameta.allure.model.TestResultContainer;
import io.qameta.allure.util.ConvertUtils;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Allure2Plugin
implements Reader {
    public static final String ALLURE2_RESULTS_FORMAT = "allure2";
    private static final Logger LOGGER = LoggerFactory.getLogger(Allure2Plugin.class);
    private static final Comparator<StageResult> BY_START = Comparator.comparing(StageResult::getTime, Comparator.nullsLast(Comparator.comparing(Time::getStart, Comparator.nullsLast(Comparator.naturalOrder()))));
    private static final Comparator<Parameter> PARAMETER_COMPARATOR = Comparator.comparing(Parameter::getName, Comparator.nullsFirst(Comparator.naturalOrder())).thenComparing(Parameter::getValue, Comparator.nullsFirst(Comparator.naturalOrder()));
    private final ObjectMapper mapper = ((JsonMapper.Builder)((JsonMapper.Builder)((JsonMapper.Builder)((JsonMapper.Builder)((JsonMapper.Builder)((JsonMapper.Builder)((JsonMapper.Builder)((JsonMapper.Builder)JsonMapper.builder().enable(new MapperFeature[]{MapperFeature.USE_WRAPPER_NAME_AS_PROPERTY_NAME})).enable(new MapperFeature[]{MapperFeature.ACCEPT_CASE_INSENSITIVE_ENUMS})).enable(new MapperFeature[]{MapperFeature.ACCEPT_CASE_INSENSITIVE_PROPERTIES})).enable(new DeserializationFeature[]{DeserializationFeature.READ_UNKNOWN_ENUM_VALUES_AS_NULL})).disable(new DeserializationFeature[]{DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES})).disable(new DeserializationFeature[]{DeserializationFeature.FAIL_ON_IGNORED_PROPERTIES})).disable(new DeserializationFeature[]{DeserializationFeature.FAIL_ON_NULL_FOR_PRIMITIVES})).disable(new DeserializationFeature[]{DeserializationFeature.FAIL_ON_NUMBERS_FOR_ENUMS})).build();

    public void readResults(Configuration configuration, ResultsVisitor visitor, Path resultsDirectory) {
        RandomUidContext context = (RandomUidContext)configuration.requireContext(RandomUidContext.class);
        ConcurrentHashMap<String, List<StageResult>> befores = new ConcurrentHashMap<String, List<StageResult>>();
        ConcurrentHashMap<String, List<StageResult>> afters = new ConcurrentHashMap<String, List<StageResult>>();
        this.readTestResultsContainers(resultsDirectory).filter(group -> !Objects.isNull(group.getChildren())).forEach(group -> {
            this.processStages(visitor, resultsDirectory, (TestResultContainer)group, (Map<String, List<StageResult>>)befores, group.getBefores());
            this.processStages(visitor, resultsDirectory, (TestResultContainer)group, (Map<String, List<StageResult>>)afters, group.getAfters());
        });
        Allure2Plugin.sortByStart(befores);
        Allure2Plugin.sortByStart(afters);
        this.readTestResults(resultsDirectory).forEach(result -> this.convert(context.getValue(), resultsDirectory, visitor, (TestResult)result, (Map<String, List<StageResult>>)befores, (Map<String, List<StageResult>>)afters));
    }

    private static void sortByStart(Map<String, List<StageResult>> befores) {
        befores.keySet().forEach(key -> befores.compute((String)key, (s, stageResults) -> {
            if (Objects.isNull(stageResults)) {
                return null;
            }
            ArrayList<StageResult> res = new ArrayList<StageResult>((Collection<StageResult>)stageResults);
            res.sort(BY_START);
            return res;
        }));
    }

    private void processStages(ResultsVisitor visitor, Path resultsDirectory, TestResultContainer group, Map<String, List<StageResult>> befores, List<FixtureResult> fixtureResults) {
        if (Objects.isNull(fixtureResults)) {
            return;
        }
        List stages = fixtureResults.stream().map(fixtureResult -> this.convert(resultsDirectory, visitor, (FixtureResult)fixtureResult)).collect(Collectors.toList());
        ConcurrentHashMap.KeySetView visited = ConcurrentHashMap.newKeySet();
        group.getChildren().parallelStream().filter(Objects::nonNull).filter(visited::add).forEach(child -> befores.compute((String)child, (s, stageResults) -> {
            if (Objects.isNull(stageResults)) {
                return new LinkedList(stages);
            }
            stageResults.addAll(stages);
            return stageResults;
        }));
    }

    private void convert(Supplier<String> uidGenerator, Path resultsDirectory, ResultsVisitor visitor, TestResult result, Map<String, List<StageResult>> befores, Map<String, List<StageResult>> afters) {
        io.qameta.allure.entity.TestResult dest = new io.qameta.allure.entity.TestResult();
        dest.setUid(uidGenerator.get());
        dest.setHistoryId(result.getHistoryId());
        dest.setFullName(result.getFullName());
        dest.setName(Allure2Plugin.firstNonNull(result.getName(), result.getFullName(), "Unknown test"));
        dest.setTime(Time.create((Long)result.getStart(), (Long)result.getStop()));
        dest.setDescription(result.getDescription());
        dest.setDescriptionHtml(result.getDescriptionHtml());
        dest.setStatus(this.convert(result.getStatus()));
        Optional.ofNullable(result.getStatusDetails()).ifPresent(details -> {
            dest.setStatusMessage(details.getMessage());
            dest.setStatusTrace(details.getTrace());
            dest.setFlaky(details.isFlaky());
        });
        dest.setLinks(ConvertUtils.convertList((Collection)result.getLinks(), this::convert));
        dest.setLabels(ConvertUtils.convertList((Collection)result.getLabels(), this::convert));
        dest.setParameters(this.getParameters(result));
        dest.addLabelIfNotExists(LabelName.RESULT_FORMAT, ALLURE2_RESULTS_FORMAT);
        if (this.hasTestStage(result)) {
            dest.setTestStage(this.getTestStage(resultsDirectory, visitor, result));
        }
        if (Objects.nonNull(result.getUuid())) {
            List<StageResult> resultAfters;
            List<StageResult> resultBefores = befores.get(result.getUuid());
            if (Objects.nonNull(resultBefores)) {
                dest.getBeforeStages().addAll(resultBefores);
            }
            if (Objects.nonNull(resultAfters = afters.get(result.getUuid()))) {
                dest.getAfterStages().addAll(resultAfters);
            }
        }
        visitor.visitTestResult(dest);
    }

    private StageResult convert(Path source, ResultsVisitor visitor, FixtureResult result) {
        StageResult stageResult = new StageResult().setName(result.getName()).setTime(this.convert(result.getStart(), result.getStop())).setStatus(this.convert(result.getStatus())).setSteps(ConvertUtils.convertList((Collection)result.getSteps(), step -> this.convert(source, visitor, (StepResult)step))).setDescription(result.getDescription()).setDescriptionHtml(result.getDescriptionHtml()).setAttachments(ConvertUtils.convertList((Collection)result.getAttachments(), attach -> this.convert(source, visitor, (Attachment)attach))).setParameters(ConvertUtils.convertList((Collection)result.getParameters(), p -> !Parameter.Mode.HIDDEN.equals((Object)p.getMode()), this::convert));
        Optional.of(result).map(FixtureResult::getStatusDetails).ifPresent(statusDetails -> {
            stageResult.setStatusMessage(statusDetails.getMessage());
            stageResult.setStatusTrace(statusDetails.getTrace());
        });
        return stageResult;
    }

    private io.qameta.allure.entity.Link convert(Link link) {
        return new io.qameta.allure.entity.Link().setName(link.getName()).setType(link.getType()).setUrl(link.getUrl());
    }

    private io.qameta.allure.entity.Label convert(Label label) {
        return new io.qameta.allure.entity.Label().setName(label.getName()).setValue(label.getValue());
    }

    private Parameter convert(io.qameta.allure.model.Parameter parameter) {
        boolean masked = Parameter.Mode.MASKED.equals((Object)parameter.getMode());
        return new Parameter().setName(parameter.getName()).setValue(masked ? "******" : parameter.getValue());
    }

    private io.qameta.allure.entity.Attachment convert(Path source, ResultsVisitor visitor, Attachment attachment) {
        Path attachmentFile = source.resolve(attachment.getSource());
        if (Files.isRegularFile(attachmentFile, new LinkOption[0])) {
            io.qameta.allure.entity.Attachment found = visitor.visitAttachmentFile(attachmentFile);
            if (Objects.nonNull(attachment.getType())) {
                found.setType(attachment.getType());
            }
            if (Objects.nonNull(attachment.getName())) {
                found.setName(attachment.getName());
            }
            return found;
        }
        visitor.error("Could not find attachment " + attachment.getSource() + " in directory " + source);
        return new io.qameta.allure.entity.Attachment().setType(attachment.getType()).setName(attachment.getName()).setSize(Long.valueOf(0L));
    }

    private Step convert(Path source, ResultsVisitor visitor, StepResult step) {
        Step result = new Step().setName(step.getName()).setStatus(this.convert(step.getStatus())).setTime(this.convert(step.getStart(), step.getStop())).setParameters(ConvertUtils.convertList((Collection)step.getParameters(), p -> !Parameter.Mode.HIDDEN.equals((Object)p.getMode()), this::convert)).setAttachments(ConvertUtils.convertList((Collection)step.getAttachments(), attachment -> this.convert(source, visitor, (Attachment)attachment))).setSteps(ConvertUtils.convertList((Collection)step.getSteps(), s -> this.convert(source, visitor, (StepResult)s)));
        Optional.of(step).map(StepResult::getStatusDetails).ifPresent(statusDetails -> {
            result.setStatusMessage(statusDetails.getMessage());
            result.setStatusTrace(statusDetails.getTrace());
        });
        return result;
    }

    private Status convert(io.qameta.allure.model.Status status) {
        if (Objects.isNull(status)) {
            return Status.UNKNOWN;
        }
        return Stream.of(Status.values()).filter(item -> item.value().equalsIgnoreCase(status.value())).findAny().orElse(Status.UNKNOWN);
    }

    private Time convert(Long start, Long stop) {
        return new Time().setStart(start).setStop(stop).setDuration(Objects.nonNull(start) && Objects.nonNull(stop) ? Long.valueOf(stop - start) : null);
    }

    private List<Parameter> getParameters(TestResult result) {
        List parameters = ConvertUtils.convertList((Collection)result.getParameters(), p -> !Parameter.Mode.HIDDEN.equals((Object)p.getMode()), this::convert);
        if (Objects.isNull(parameters)) {
            return new ArrayList<Parameter>();
        }
        TreeSet<Parameter> parametersSet = new TreeSet<Parameter>(PARAMETER_COMPARATOR);
        parametersSet.addAll(parameters);
        return new ArrayList<Parameter>(parametersSet);
    }

    private StageResult getTestStage(Path source, ResultsVisitor visitor, TestResult result) {
        StageResult testStage = new StageResult();
        testStage.setSteps(ConvertUtils.convertList((Collection)result.getSteps(), step -> this.convert(source, visitor, (StepResult)step)));
        testStage.setAttachments(ConvertUtils.convertList((Collection)result.getAttachments(), attachment -> this.convert(source, visitor, (Attachment)attachment)));
        testStage.setStatus(this.convert(result.getStatus()));
        testStage.setDescription(result.getDescription());
        testStage.setDescriptionHtml(result.getDescriptionHtml());
        Optional.of(result).map(TestResult::getStatusDetails).ifPresent(statusDetails -> {
            testStage.setStatusMessage(statusDetails.getMessage());
            testStage.setStatusTrace(statusDetails.getTrace());
        });
        return testStage;
    }

    private boolean hasTestStage(TestResult result) {
        return !result.getSteps().isEmpty() || !result.getAttachments().isEmpty();
    }

    @SafeVarargs
    private static <T> T firstNonNull(T ... items) {
        return (T)Stream.of(items).filter(Objects::nonNull).findFirst().orElseThrow(() -> new IllegalStateException("firstNonNull method should have at least one non null parameter"));
    }

    private Stream<TestResultContainer> readTestResultsContainers(Path resultsDirectory) {
        return ((Stream)this.listFiles(resultsDirectory, "*-container.json").parallel()).map(this::readTestResultContainer).filter(Optional::isPresent).map(Optional::get);
    }

    private Stream<TestResult> readTestResults(Path resultsDirectory) {
        return ((Stream)this.listFiles(resultsDirectory, "*-result.json").parallel()).map(this::readTestResult).filter(Optional::isPresent).map(Optional::get);
    }

    private Optional<TestResult> readTestResult(Path file) {
        Optional<TestResult> optional;
        block8: {
            InputStream is = Files.newInputStream(file, new OpenOption[0]);
            try {
                optional = Optional.ofNullable((TestResult)this.mapper.readValue(is, TestResult.class));
                if (is == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    LOGGER.error("Could not read test result file {}", (Object)file, (Object)e);
                    return Optional.empty();
                }
            }
            is.close();
        }
        return optional;
    }

    private Optional<TestResultContainer> readTestResultContainer(Path file) {
        Optional<TestResultContainer> optional;
        block8: {
            InputStream is = Files.newInputStream(file, new OpenOption[0]);
            try {
                optional = Optional.ofNullable((TestResultContainer)this.mapper.readValue(is, TestResultContainer.class));
                if (is == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    LOGGER.error("Could not read result container file {}", (Object)file, (Object)e);
                    return Optional.empty();
                }
            }
            is.close();
        }
        return optional;
    }

    private Stream<Path> listFiles(Path directory, String glob) {
        Stream<Path> stream;
        block8: {
            DirectoryStream<Path> directoryStream = Files.newDirectoryStream(directory, glob);
            try {
                stream = StreamSupport.stream(directoryStream.spliterator(), true).filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).collect(Collectors.toList()).stream();
                if (directoryStream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (directoryStream != null) {
                        try {
                            directoryStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    LOGGER.error("Could not list files in directory {}", (Object)directory, (Object)e);
                    return Stream.empty();
                }
            }
            directoryStream.close();
        }
        return stream;
    }
}

