/*
 * Decompiled with CFR 0.152.
 */
package io.qameta.allure.cucumberjvm;

import cucumber.runtime.CucumberException;
import cucumber.runtime.StepDefinitionMatch;
import gherkin.formatter.model.Feature;
import gherkin.formatter.model.Match;
import gherkin.formatter.model.Result;
import gherkin.formatter.model.Scenario;
import gherkin.formatter.model.Step;
import io.qameta.allure.Allure;
import io.qameta.allure.AllureLifecycle;
import io.qameta.allure.cucumberjvm.TagParser;
import io.qameta.allure.model.Status;
import io.qameta.allure.model.StatusDetails;
import io.qameta.allure.model.StepResult;
import io.qameta.allure.util.ResultsUtils;
import java.lang.reflect.Field;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class StepUtils {
    private static final Logger LOG = LoggerFactory.getLogger(StepUtils.class);
    private static final String FAILED = "failed";
    private final AllureLifecycle lifecycle = Allure.getLifecycle();
    private final Feature feature;
    private final Scenario scenario;

    StepUtils(Feature feature, Scenario scenario) {
        this.feature = feature;
        this.scenario = scenario;
    }

    protected Step extractStep(StepDefinitionMatch match) {
        try {
            Field step = match.getClass().getDeclaredField("step");
            step.setAccessible(true);
            return (Step)step.get(match);
        }
        catch (ReflectiveOperationException e) {
            LOG.error(e.getMessage(), (Throwable)e);
            throw new CucumberException((Throwable)e);
        }
    }

    protected boolean isEqualSteps(Step step, Step gherkinStep) {
        return Objects.equals(step.getLine(), gherkinStep.getLine());
    }

    protected void fireCanceledStep(Step unimplementedStep) {
        StepResult stepResult = new StepResult();
        stepResult.setName(unimplementedStep.getName()).setStart(Long.valueOf(System.currentTimeMillis())).setStop(Long.valueOf(System.currentTimeMillis())).setStatus(Status.SKIPPED).setStatusDetails(new StatusDetails().setMessage("Unimplemented step"));
        this.lifecycle.startStep(this.scenario.getId(), this.getStepUuid(unimplementedStep), stepResult);
        this.lifecycle.stopStep(this.getStepUuid(unimplementedStep));
        StatusDetails statusDetails = new StatusDetails();
        TagParser tagParser = new TagParser(this.feature, this.scenario);
        statusDetails.setFlaky(tagParser.isFlaky()).setMuted(tagParser.isMuted()).setKnown(tagParser.isKnown());
        this.lifecycle.updateTestCase(this.scenario.getId(), scenarioResult -> scenarioResult.setStatus(Status.SKIPPED).setStatusDetails(statusDetails.setMessage("Unimplemented steps were found")));
    }

    protected String getStepUuid(Step step) {
        return this.feature.getId() + this.scenario.getId() + step.getName() + step.getLine();
    }

    protected static String getHistoryId(String id) {
        return ResultsUtils.md5((String)id);
    }

    protected void fireFixtureStep(Match match, Result result, boolean isBefore) {
        String uuid = ResultsUtils.md5((String)match.getLocation());
        StepResult stepResult = new StepResult().setName(match.getLocation()).setStatus(Status.fromValue((String)result.getStatus())).setStart(Long.valueOf(System.currentTimeMillis() - result.getDuration())).setStop(Long.valueOf(System.currentTimeMillis()));
        if (FAILED.equals(result.getStatus())) {
            StatusDetails statusDetails = (StatusDetails)ResultsUtils.getStatusDetails((Throwable)result.getError()).get();
            stepResult.setStatusDetails(statusDetails);
            if (isBefore) {
                TagParser tagParser = new TagParser(this.feature, this.scenario);
                statusDetails.setMessage("Before is failed: " + result.getError().getLocalizedMessage()).setFlaky(tagParser.isFlaky()).setMuted(tagParser.isMuted()).setKnown(tagParser.isKnown());
                this.lifecycle.updateTestCase(this.scenario.getId(), scenarioResult -> scenarioResult.setStatus(Status.SKIPPED).setStatusDetails(statusDetails));
            }
        }
        this.lifecycle.startStep(this.scenario.getId(), uuid, stepResult);
        this.lifecycle.stopStep(uuid);
    }
}

