/*
 * Decompiled with CFR 0.152.
 */
package io.qameta.allure.cucumberjvm;

import cucumber.runtime.StepDefinitionMatch;
import gherkin.I18n;
import gherkin.formatter.Formatter;
import gherkin.formatter.Reporter;
import gherkin.formatter.model.Background;
import gherkin.formatter.model.DataTableRow;
import gherkin.formatter.model.Examples;
import gherkin.formatter.model.Feature;
import gherkin.formatter.model.Match;
import gherkin.formatter.model.Result;
import gherkin.formatter.model.Scenario;
import gherkin.formatter.model.ScenarioOutline;
import gherkin.formatter.model.Step;
import gherkin.formatter.model.Tag;
import io.qameta.allure.Allure;
import io.qameta.allure.AllureLifecycle;
import io.qameta.allure.cucumberjvm.LabelBuilder;
import io.qameta.allure.cucumberjvm.StepUtils;
import io.qameta.allure.cucumberjvm.TagParser;
import io.qameta.allure.model.Status;
import io.qameta.allure.model.StatusDetails;
import io.qameta.allure.model.StepResult;
import io.qameta.allure.model.TestResult;
import io.qameta.allure.util.ResultsUtils;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Deque;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;

public class AllureCucumberJvm
implements Reporter,
Formatter {
    private static final List<String> SCENARIO_OUTLINE_KEYWORDS = Collections.synchronizedList(new ArrayList());
    private static final String FAILED = "failed";
    private static final String PASSED = "passed";
    private static final String SKIPPED = "skipped";
    private static final String PENDING = "pending";
    private static final String TXT_EXTENSION = ".txt";
    private static final String TEXT_PLAIN = "text/plain";
    private final Map<Scenario, String> scenarioUuids = new ConcurrentHashMap<Scenario, String>();
    private final Deque<Step> gherkinSteps = new LinkedList<Step>();
    private final AllureLifecycle lifecycle;
    private Feature currentFeature;
    private boolean isNullMatch = true;
    private Scenario currentScenario;

    public AllureCucumberJvm() {
        this(Allure.getLifecycle());
    }

    public AllureCucumberJvm(AllureLifecycle lifecycle) {
        this.lifecycle = lifecycle;
        List i18nList = I18n.getAll();
        i18nList.forEach(i18n -> SCENARIO_OUTLINE_KEYWORDS.addAll(i18n.keywords("scenario_outline")));
    }

    public void feature(Feature feature) {
        this.currentFeature = feature;
    }

    public void before(Match match, Result result) {
        new StepUtils(this.currentFeature, this.currentScenario).fireFixtureStep(match, result, true);
    }

    public void after(Match match, Result result) {
        new StepUtils(this.currentFeature, this.currentScenario).fireFixtureStep(match, result, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startOfScenarioLifeCycle(Scenario scenario) {
        this.currentScenario = scenario;
        LinkedList<Tag> tags = new LinkedList<Tag>(scenario.getTags());
        if (SCENARIO_OUTLINE_KEYWORDS.contains(scenario.getKeyword())) {
            Deque<Step> deque = this.gherkinSteps;
            synchronized (deque) {
                this.gherkinSteps.clear();
            }
        } else {
            tags.addAll(this.currentFeature.getTags());
        }
        LabelBuilder labelBuilder = new LabelBuilder(this.currentFeature, scenario, tags);
        String uuid = UUID.randomUUID().toString();
        this.scenarioUuids.put(scenario, uuid);
        TestResult result = new TestResult().setUuid(uuid).setHistoryId(StepUtils.getHistoryId(scenario.getId())).setFullName(String.format("%s: %s", this.currentFeature.getName(), scenario.getName())).setName(scenario.getName()).setLabels(labelBuilder.getScenarioLabels()).setLinks(labelBuilder.getScenarioLinks());
        if (!this.currentFeature.getDescription().isEmpty()) {
            result.setDescription(this.currentFeature.getDescription());
        }
        this.lifecycle.scheduleTestCase(result);
        this.lifecycle.startTestCase(uuid);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void step(Step step) {
        Deque<Step> deque = this.gherkinSteps;
        synchronized (deque) {
            this.gherkinSteps.add(step);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void match(Match match) {
        StepUtils stepUtils = new StepUtils(this.currentFeature, this.currentScenario);
        if (match instanceof StepDefinitionMatch) {
            this.isNullMatch = false;
            Step step = stepUtils.extractStep((StepDefinitionMatch)match);
            Deque<Step> deque = this.gherkinSteps;
            synchronized (deque) {
                while (this.gherkinSteps.peek() != null && !stepUtils.isEqualSteps(step, this.gherkinSteps.peek())) {
                    stepUtils.fireCanceledStep(this.gherkinSteps.remove());
                }
                if (stepUtils.isEqualSteps(step, this.gherkinSteps.peek())) {
                    this.gherkinSteps.remove();
                }
            }
            StepResult stepResult = new StepResult();
            stepResult.setName(String.format("%s %s", step.getKeyword(), this.getStepName(step))).setStart(Long.valueOf(System.currentTimeMillis()));
            String scenarioUuid = this.scenarioUuids.get(this.currentScenario);
            this.lifecycle.startStep(scenarioUuid, stepUtils.getStepUuid(step), stepResult);
            this.createDataTableAttachment(step.getRows());
        }
    }

    public void result(Result result) {
        if (!this.isNullMatch) {
            StatusDetails statusDetails = ResultsUtils.getStatusDetails((Throwable)result.getError()).orElse(new StatusDetails());
            TagParser tagParser = new TagParser(this.currentFeature, this.currentScenario);
            statusDetails.setFlaky(tagParser.isFlaky()).setMuted(tagParser.isMuted()).setKnown(tagParser.isKnown());
            String scenarioUuid = this.scenarioUuids.get(this.currentScenario);
            switch (result.getStatus()) {
                case "failed": {
                    Status status = ResultsUtils.getStatus((Throwable)result.getError()).orElse(Status.FAILED);
                    this.lifecycle.updateStep(stepResult -> stepResult.setStatus(Status.FAILED));
                    this.lifecycle.updateTestCase(scenarioUuid, scenarioResult -> scenarioResult.setStatus(status).setStatusDetails(statusDetails));
                    this.lifecycle.stopStep();
                    break;
                }
                case "pending": {
                    this.lifecycle.updateStep(stepResult -> stepResult.setStatus(Status.SKIPPED));
                    this.lifecycle.updateTestCase(scenarioUuid, scenarioResult -> scenarioResult.setStatus(Status.SKIPPED).setStatusDetails(statusDetails));
                    this.lifecycle.stopStep();
                    break;
                }
                case "skipped": {
                    this.lifecycle.updateStep(stepResult -> stepResult.setStatus(Status.SKIPPED));
                    this.lifecycle.stopStep();
                    break;
                }
                case "passed": {
                    this.lifecycle.updateStep(stepResult -> stepResult.setStatus(Status.PASSED));
                    this.lifecycle.stopStep();
                    this.lifecycle.updateTestCase(scenarioUuid, scenarioResult -> scenarioResult.setStatus(Status.PASSED).setStatusDetails(statusDetails));
                    break;
                }
            }
            this.isNullMatch = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void endOfScenarioLifeCycle(Scenario scenario) {
        StepUtils stepUtils = new StepUtils(this.currentFeature, this.currentScenario);
        Deque<Step> deque = this.gherkinSteps;
        synchronized (deque) {
            while (this.gherkinSteps.peek() != null) {
                stepUtils.fireCanceledStep(this.gherkinSteps.remove());
            }
        }
        String scenarioUuid = this.scenarioUuids.remove(scenario);
        this.lifecycle.stopTestCase(scenarioUuid);
        this.lifecycle.writeTestCase(scenarioUuid);
    }

    public String getStepName(Step step) {
        return step.getName();
    }

    private void createDataTableAttachment(List<DataTableRow> dataTableRows) {
        StringBuilder dataTableCsv = new StringBuilder();
        if (dataTableRows != null && !dataTableRows.isEmpty()) {
            dataTableRows.forEach(dataTableRow -> {
                dataTableCsv.append(String.join((CharSequence)"\t", dataTableRow.getCells()));
                dataTableCsv.append('\n');
            });
            String attachmentSource = this.lifecycle.prepareAttachment("Data table", "text/tab-separated-values", "csv");
            this.lifecycle.writeAttachment(attachmentSource, (InputStream)new ByteArrayInputStream(dataTableCsv.toString().getBytes(StandardCharsets.UTF_8)));
        }
    }

    public void embedding(String string, byte[] bytes) {
        this.lifecycle.addAttachment("Screenshot", null, null, (InputStream)new ByteArrayInputStream(bytes));
    }

    public void write(String string) {
        this.lifecycle.addAttachment("Text output", TEXT_PLAIN, TXT_EXTENSION, Objects.toString(string).getBytes(StandardCharsets.UTF_8));
    }

    public void syntaxError(String state, String event, List<String> legalEvents, String uri, Integer line) {
    }

    public void uri(String uri) {
    }

    public void scenarioOutline(ScenarioOutline so) {
    }

    public void examples(Examples exmpls) {
    }

    public void background(Background b) {
    }

    public void scenario(Scenario scnr) {
    }

    public void done() {
    }

    public void close() {
    }

    public void eof() {
    }
}

