/*
 * Decompiled with CFR 0.152.
 */
package io.qameta.allure.cucumberjvm;

import gherkin.formatter.model.Feature;
import gherkin.formatter.model.Scenario;
import gherkin.formatter.model.Tag;
import io.qameta.allure.SeverityLevel;
import java.util.Arrays;

class TagParser {
    private static final String FLAKY = "@FLAKY";
    private static final String KNOWN = "@KNOWN";
    private static final String MUTED = "@MUTED";
    private final Feature feature;
    private final Scenario scenario;

    TagParser(Feature feature, Scenario scenario) {
        this.feature = feature;
        this.scenario = scenario;
    }

    protected boolean isFlaky() {
        return this.getStatusDetailByTag(FLAKY);
    }

    protected boolean isMuted() {
        return this.getStatusDetailByTag(MUTED);
    }

    protected boolean isKnown() {
        return this.getStatusDetailByTag(KNOWN);
    }

    protected boolean getStatusDetailByTag(String tagName) {
        return this.scenario.getTags().stream().anyMatch(tag -> tag.getName().equalsIgnoreCase(tagName)) || this.feature.getTags().stream().anyMatch(tag -> tag.getName().equalsIgnoreCase(tagName));
    }

    protected boolean isResultTag(Tag tag) {
        return Arrays.asList(FLAKY, KNOWN, MUTED).contains(tag.getName().toUpperCase());
    }

    protected boolean isPureSeverityTag(Tag tag) {
        return Arrays.stream(SeverityLevel.values()).map(SeverityLevel::value).map(value -> "@" + value).anyMatch(value -> value.equalsIgnoreCase(tag.getName()));
    }
}

