/*
 * Decompiled with CFR 0.152.
 */
package io.qameta.allure.cucumberjvm;

import gherkin.formatter.model.Feature;
import gherkin.formatter.model.Scenario;
import gherkin.formatter.model.Tag;
import io.qameta.allure.cucumberjvm.TagParser;
import io.qameta.allure.model.Label;
import io.qameta.allure.model.Link;
import io.qameta.allure.util.ResultsUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Deque;
import java.util.List;
import java.util.Objects;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class LabelBuilder {
    private static final Logger LOGGER = LoggerFactory.getLogger(LabelBuilder.class);
    private static final String COMPOSITE_TAG_DELIMITER = "=";
    private static final String SEVERITY = "@SEVERITY";
    private static final String ISSUE_LINK = "@ISSUE";
    private static final String TMS_LINK = "@TMSLINK";
    private static final String PLAIN_LINK = "@LINK";
    private final List<Label> scenarioLabels = new ArrayList<Label>();
    private final List<Link> scenarioLinks = new ArrayList<Link>();

    LabelBuilder(Feature feature, Scenario scenario, Deque<Tag> tags) {
        TagParser tagParser = new TagParser(feature, scenario);
        this.getScenarioLabels().add(ResultsUtils.createFeatureLabel((String)feature.getName()));
        this.getScenarioLabels().add(ResultsUtils.createStoryLabel((String)scenario.getName()));
        while (tags.peek() != null) {
            Tag tag = tags.remove();
            String tagString = tag.getName();
            if (tagString.contains(COMPOSITE_TAG_DELIMITER)) {
                String[] tagParts = tagString.split(COMPOSITE_TAG_DELIMITER, 2);
                if (tagParts.length < 2 || Objects.isNull(tagParts[1]) || tagParts[1].isEmpty()) continue;
                String tagKey = tagParts[0].toUpperCase();
                String tagValue = tagParts[1];
                if (tagKey.startsWith("@LINK.")) {
                    this.tryHandleNamedLink(tagString);
                    continue;
                }
                switch (tagKey) {
                    case "@SEVERITY": {
                        this.getScenarioLabels().add(ResultsUtils.createSeverityLabel((String)tagValue.toLowerCase()));
                        break;
                    }
                    case "@TMSLINK": {
                        this.getScenarioLinks().add(ResultsUtils.createTmsLink((String)tagValue));
                        break;
                    }
                    case "@ISSUE": {
                        this.getScenarioLinks().add(ResultsUtils.createIssueLink((String)tagValue));
                        break;
                    }
                    case "@LINK": {
                        this.getScenarioLinks().add(ResultsUtils.createLink(null, (String)tagValue, (String)tagValue, null));
                        break;
                    }
                    default: {
                        LOGGER.warn("Composite tag {} is not supported. adding it as RAW", (Object)tagKey);
                        this.getScenarioLabels().add(this.getTagLabel(tag));
                        break;
                    }
                }
                continue;
            }
            if (tagParser.isPureSeverityTag(tag)) {
                this.getScenarioLabels().add(ResultsUtils.createSeverityLabel((String)tagString.substring(1)));
                continue;
            }
            if (tagParser.isResultTag(tag)) continue;
            this.getScenarioLabels().add(this.getTagLabel(tag));
        }
        this.getScenarioLabels().addAll(ResultsUtils.getProvidedLabels());
        this.getScenarioLabels().addAll(Arrays.asList(ResultsUtils.createHostLabel(), ResultsUtils.createThreadLabel(), ResultsUtils.createPackageLabel((String)feature.getName()), ResultsUtils.createSuiteLabel((String)feature.getName()), ResultsUtils.createTestClassLabel((String)scenario.getName()), ResultsUtils.createFrameworkLabel((String)"cucumberjvm"), ResultsUtils.createLanguageLabel((String)"java")));
    }

    public List<Label> getScenarioLabels() {
        return this.scenarioLabels;
    }

    public List<Link> getScenarioLinks() {
        return this.scenarioLinks;
    }

    private Label getTagLabel(Tag tag) {
        return ResultsUtils.createTagLabel((String)tag.getName().substring(1));
    }

    private void tryHandleNamedLink(String tagString) {
        String namedLinkPatternString = "@LINK\\.(\\w+-?)+=(\\w+(-|_)?)+";
        Pattern namedLinkPattern = Pattern.compile("@LINK\\.(\\w+-?)+=(\\w+(-|_)?)+", 2);
        if (namedLinkPattern.matcher(tagString).matches()) {
            String type = tagString.split(COMPOSITE_TAG_DELIMITER)[0].split("[.]")[1];
            String name = tagString.split(COMPOSITE_TAG_DELIMITER)[1];
            this.getScenarioLinks().add(ResultsUtils.createLink(null, (String)name, null, (String)type));
        } else {
            LOGGER.warn("Composite named tag {} is not matches regex {}. skipping", (Object)tagString, (Object)"@LINK\\.(\\w+-?)+=(\\w+(-|_)?)+");
        }
    }
}

