/*
 * Decompiled with CFR 0.152.
 */
package io.qameta.allure.cucumber4jvm;

import cucumber.api.TestCase;
import gherkin.ast.Feature;
import gherkin.pickles.PickleTag;
import io.qameta.allure.cucumber4jvm.TagParser;
import io.qameta.allure.model.Label;
import io.qameta.allure.model.Link;
import io.qameta.allure.util.ResultsUtils;
import java.net.URI;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Deque;
import java.util.List;
import java.util.Objects;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class LabelBuilder {
    private static final Logger LOGGER = LoggerFactory.getLogger(LabelBuilder.class);
    private static final String COMPOSITE_TAG_DELIMITER = "=";
    private static final String SEVERITY = "@SEVERITY";
    private static final String ISSUE_LINK = "@ISSUE";
    private static final String TMS_LINK = "@TMSLINK";
    private static final String PLAIN_LINK = "@LINK";
    private final List<Label> scenarioLabels = new ArrayList<Label>();
    private final List<Link> scenarioLinks = new ArrayList<Link>();

    LabelBuilder(Feature feature, TestCase scenario, Deque<PickleTag> tags) {
        TagParser tagParser = new TagParser(feature, scenario);
        while (tags.peek() != null) {
            PickleTag tag = tags.remove();
            String tagString = tag.getName();
            if (tagString.contains(COMPOSITE_TAG_DELIMITER)) {
                String[] tagParts = tagString.split(COMPOSITE_TAG_DELIMITER, 2);
                if (tagParts.length < 2 || Objects.isNull(tagParts[1]) || tagParts[1].isEmpty()) continue;
                String tagKey = tagParts[0].toUpperCase();
                String tagValue = tagParts[1];
                if (tagKey.startsWith("@LINK.")) {
                    this.tryHandleNamedLink(tagString);
                    continue;
                }
                switch (tagKey) {
                    case "@SEVERITY": {
                        this.getScenarioLabels().add(ResultsUtils.createSeverityLabel((String)tagValue.toLowerCase()));
                        break;
                    }
                    case "@TMSLINK": {
                        this.getScenarioLinks().add(ResultsUtils.createTmsLink((String)tagValue));
                        break;
                    }
                    case "@ISSUE": {
                        this.getScenarioLinks().add(ResultsUtils.createIssueLink((String)tagValue));
                        break;
                    }
                    case "@LINK": {
                        this.getScenarioLinks().add(ResultsUtils.createLink(null, (String)tagValue, (String)tagValue, null));
                        break;
                    }
                    default: {
                        LOGGER.warn("Composite tag {} is not supported. adding it as RAW", (Object)tagKey);
                        this.getScenarioLabels().add(this.getTagLabel(tag));
                        break;
                    }
                }
                continue;
            }
            if (tagParser.isPureSeverityTag(tag)) {
                this.getScenarioLabels().add(ResultsUtils.createSeverityLabel((String)tagString.substring(1)));
                continue;
            }
            if (tagParser.isResultTag(tag)) continue;
            this.getScenarioLabels().add(this.getTagLabel(tag));
        }
        String featureName = feature.getName();
        String uri = scenario.getUri();
        this.getScenarioLabels().addAll(Arrays.asList(ResultsUtils.createHostLabel(), ResultsUtils.createThreadLabel(), ResultsUtils.createFeatureLabel((String)featureName), ResultsUtils.createStoryLabel((String)scenario.getName()), ResultsUtils.createPackageLabel((String)this.featurePackage(uri, featureName)), ResultsUtils.createSuiteLabel((String)featureName), ResultsUtils.createTestClassLabel((String)scenario.getName()), ResultsUtils.createFrameworkLabel((String)"cucumber4jvm"), ResultsUtils.createLanguageLabel((String)"java"), ResultsUtils.createLabel((String)"gherkin_uri", (String)uri)));
    }

    public List<Label> getScenarioLabels() {
        return this.scenarioLabels;
    }

    public List<Link> getScenarioLinks() {
        return this.scenarioLinks;
    }

    private Label getTagLabel(PickleTag tag) {
        return ResultsUtils.createTagLabel((String)tag.getName().substring(1));
    }

    private void tryHandleNamedLink(String tagString) {
        String namedLinkPatternString = "@LINK\\.(\\w+-?)+=(\\w+(-|_)?)+";
        Pattern namedLinkPattern = Pattern.compile("@LINK\\.(\\w+-?)+=(\\w+(-|_)?)+", 2);
        if (namedLinkPattern.matcher(tagString).matches()) {
            String type = tagString.split(COMPOSITE_TAG_DELIMITER)[0].split("[.]")[1];
            String name = tagString.split(COMPOSITE_TAG_DELIMITER)[1];
            this.getScenarioLinks().add(ResultsUtils.createLink(null, (String)name, null, (String)type));
        } else {
            LOGGER.warn("Composite named tag {} does not match regex {}. Skipping", (Object)tagString, (Object)"@LINK\\.(\\w+-?)+=(\\w+(-|_)?)+");
        }
    }

    private String featurePackage(String uri, String featureName) {
        Path parent = Paths.get(URI.create(uri).getSchemeSpecificPart(), new String[0]).getParent();
        if (Objects.nonNull(parent)) {
            Stream<String> folders = StreamSupport.stream(parent.spliterator(), false).map(Path::toString);
            Stream<String> name = Stream.of(featureName);
            return Stream.concat(folders, name).collect(Collectors.joining("."));
        }
        return featureName;
    }
}

