/*
 * Decompiled with CFR 0.152.
 */
package io.qameta.allure.cucumber4jvm;

import cucumber.api.HookTestStep;
import cucumber.api.HookType;
import cucumber.api.PendingException;
import cucumber.api.PickleStepTestStep;
import cucumber.api.Result;
import cucumber.api.TestCase;
import cucumber.api.event.ConcurrentEventListener;
import cucumber.api.event.EmbedEvent;
import cucumber.api.event.EventHandler;
import cucumber.api.event.EventPublisher;
import cucumber.api.event.TestCaseFinished;
import cucumber.api.event.TestCaseStarted;
import cucumber.api.event.TestSourceRead;
import cucumber.api.event.TestStepFinished;
import cucumber.api.event.TestStepStarted;
import cucumber.api.event.WriteEvent;
import cucumber.runtime.formatter.TestSourcesModelProxy;
import gherkin.ast.Examples;
import gherkin.ast.Feature;
import gherkin.ast.ScenarioDefinition;
import gherkin.ast.ScenarioOutline;
import gherkin.ast.TableCell;
import gherkin.ast.TableRow;
import gherkin.pickles.PickleCell;
import gherkin.pickles.PickleTable;
import gherkin.pickles.PickleTag;
import io.qameta.allure.Allure;
import io.qameta.allure.AllureLifecycle;
import io.qameta.allure.cucumber4jvm.LabelBuilder;
import io.qameta.allure.cucumber4jvm.TagParser;
import io.qameta.allure.model.FixtureResult;
import io.qameta.allure.model.Parameter;
import io.qameta.allure.model.Status;
import io.qameta.allure.model.StatusDetails;
import io.qameta.allure.model.StepResult;
import io.qameta.allure.model.TestResult;
import io.qameta.allure.model.TestResultContainer;
import io.qameta.allure.util.ResultsUtils;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;

public class AllureCucumber4Jvm
implements ConcurrentEventListener {
    private final AllureLifecycle lifecycle;
    private final ConcurrentHashMap<String, String> scenarioUuids = new ConcurrentHashMap();
    private final TestSourcesModelProxy testSources = new TestSourcesModelProxy();
    private final ThreadLocal<Feature> currentFeature = new InheritableThreadLocal<Feature>();
    private final ThreadLocal<String> currentFeatureFile = new InheritableThreadLocal<String>();
    private final ThreadLocal<TestCase> currentTestCase = new InheritableThreadLocal<TestCase>();
    private final ThreadLocal<String> currentContainer = new InheritableThreadLocal<String>();
    private final ThreadLocal<Boolean> forbidTestCaseStatusChange = new InheritableThreadLocal<Boolean>();
    private final EventHandler<TestSourceRead> featureStartedHandler = this::handleFeatureStartedHandler;
    private final EventHandler<TestCaseStarted> caseStartedHandler = this::handleTestCaseStarted;
    private final EventHandler<TestCaseFinished> caseFinishedHandler = this::handleTestCaseFinished;
    private final EventHandler<TestStepStarted> stepStartedHandler = this::handleTestStepStarted;
    private final EventHandler<TestStepFinished> stepFinishedHandler = this::handleTestStepFinished;
    private final EventHandler<WriteEvent> writeEventHandler = this::handleWriteEvent;
    private final EventHandler<EmbedEvent> embedEventHandler = this::handleEmbedEvent;
    private static final String TXT_EXTENSION = ".txt";
    private static final String TEXT_PLAIN = "text/plain";

    public AllureCucumber4Jvm() {
        this(Allure.getLifecycle());
    }

    public AllureCucumber4Jvm(AllureLifecycle lifecycle) {
        this.lifecycle = lifecycle;
    }

    public void setEventPublisher(EventPublisher publisher) {
        publisher.registerHandlerFor(TestSourceRead.class, this.featureStartedHandler);
        publisher.registerHandlerFor(TestCaseStarted.class, this.caseStartedHandler);
        publisher.registerHandlerFor(TestCaseFinished.class, this.caseFinishedHandler);
        publisher.registerHandlerFor(TestStepStarted.class, this.stepStartedHandler);
        publisher.registerHandlerFor(TestStepFinished.class, this.stepFinishedHandler);
        publisher.registerHandlerFor(WriteEvent.class, this.writeEventHandler);
        publisher.registerHandlerFor(EmbedEvent.class, this.embedEventHandler);
    }

    private void handleFeatureStartedHandler(TestSourceRead event) {
        this.testSources.addTestSourceReadEvent(event.uri, event);
    }

    private void handleTestCaseStarted(TestCaseStarted event) {
        String description;
        this.currentFeatureFile.set(event.testCase.getUri());
        this.currentFeature.set(this.testSources.getFeature(this.currentFeatureFile.get()));
        this.currentTestCase.set(event.testCase);
        this.currentContainer.set(UUID.randomUUID().toString());
        this.forbidTestCaseStatusChange.set(false);
        LinkedList<PickleTag> tags = new LinkedList<PickleTag>(this.currentTestCase.get().getTags());
        Feature feature = this.currentFeature.get();
        LabelBuilder labelBuilder = new LabelBuilder(feature, this.currentTestCase.get(), tags);
        String name = this.currentTestCase.get().getName();
        String featureName = feature.getName();
        TestResult result = new TestResult().setUuid(this.getTestCaseUuid(this.currentTestCase.get())).setHistoryId(this.getHistoryId(this.currentTestCase.get())).setFullName(featureName + ": " + name).setName(name).setLabels(labelBuilder.getScenarioLabels()).setLinks(labelBuilder.getScenarioLinks());
        ScenarioDefinition scenarioDefinition = this.testSources.getScenarioDefinition(this.currentFeatureFile.get(), this.currentTestCase.get().getLine());
        if (scenarioDefinition instanceof ScenarioOutline) {
            result.setParameters(this.getExamplesAsParameters((ScenarioOutline)scenarioDefinition, this.currentTestCase.get()));
        }
        if (!(description = Stream.of(feature.getDescription(), scenarioDefinition.getDescription()).filter(Objects::nonNull).filter(s -> !s.isEmpty()).collect(Collectors.joining("\n"))).isEmpty()) {
            result.setDescription(description);
        }
        TestResultContainer resultContainer = new TestResultContainer().setName(String.format("%s: %s", scenarioDefinition.getKeyword(), scenarioDefinition.getName())).setUuid(this.getTestContainerUuid()).setChildren(Collections.singletonList(this.getTestCaseUuid(this.currentTestCase.get())));
        this.lifecycle.scheduleTestCase(result);
        this.lifecycle.startTestContainer(this.getTestContainerUuid(), resultContainer);
        this.lifecycle.startTestCase(this.getTestCaseUuid(this.currentTestCase.get()));
    }

    private void handleTestCaseFinished(TestCaseFinished event) {
        String uuid = this.getTestCaseUuid(event.testCase);
        Optional details = ResultsUtils.getStatusDetails((Throwable)event.result.getError());
        details.ifPresent(statusDetails -> this.lifecycle.updateTestCase(uuid, testResult -> testResult.setStatusDetails(statusDetails)));
        this.lifecycle.stopTestCase(uuid);
        this.lifecycle.stopTestContainer(this.getTestContainerUuid());
        this.lifecycle.writeTestCase(uuid);
        this.lifecycle.writeTestContainer(this.getTestContainerUuid());
    }

    private void handleTestStepStarted(TestStepStarted event) {
        if (event.testStep instanceof PickleStepTestStep) {
            PickleStepTestStep pickleStep = (PickleStepTestStep)event.testStep;
            String stepKeyword = Optional.ofNullable(this.testSources.getKeywordFromSource(this.currentFeatureFile.get(), pickleStep.getStepLine())).orElse("UNDEFINED");
            StepResult stepResult = new StepResult().setName(String.format("%s %s", stepKeyword, pickleStep.getPickleStep().getText())).setStart(Long.valueOf(System.currentTimeMillis()));
            this.lifecycle.startStep(this.getTestCaseUuid(this.currentTestCase.get()), this.getStepUuid(pickleStep), stepResult);
            pickleStep.getStepArgument().stream().filter(PickleTable.class::isInstance).findFirst().ifPresent(table -> this.createDataTableAttachment((PickleTable)table));
        } else if (event.testStep instanceof HookTestStep) {
            this.initHook((HookTestStep)event.testStep);
        }
    }

    private void initHook(HookTestStep hook) {
        FixtureResult hookResult = new FixtureResult().setName(hook.getCodeLocation()).setStart(Long.valueOf(System.currentTimeMillis()));
        if (hook.getHookType() == HookType.Before) {
            this.lifecycle.startPrepareFixture(this.getTestContainerUuid(), this.getHookStepUuid(hook), hookResult);
        } else {
            this.lifecycle.startTearDownFixture(this.getTestContainerUuid(), this.getHookStepUuid(hook), hookResult);
        }
    }

    private void handleTestStepFinished(TestStepFinished event) {
        if (event.testStep instanceof HookTestStep) {
            this.handleHookStep(event);
        } else {
            this.handlePickleStep(event);
        }
    }

    private void handleWriteEvent(WriteEvent event) {
        this.lifecycle.addAttachment("Text output", TEXT_PLAIN, TXT_EXTENSION, Objects.toString(event.text).getBytes(StandardCharsets.UTF_8));
    }

    private void handleEmbedEvent(EmbedEvent event) {
        this.lifecycle.addAttachment("Screenshot", null, null, (InputStream)new ByteArrayInputStream(event.data));
    }

    private String getTestContainerUuid() {
        return this.currentContainer.get();
    }

    private String getTestCaseUuid(TestCase testCase) {
        return this.scenarioUuids.computeIfAbsent(this.getHistoryId(testCase), it -> UUID.randomUUID().toString());
    }

    private String getStepUuid(PickleStepTestStep step) {
        return this.currentFeature.get().getName() + this.getTestCaseUuid(this.currentTestCase.get()) + step.getPickleStep().getText() + step.getStepLine();
    }

    private String getHookStepUuid(HookTestStep step) {
        return this.currentFeature.get().getName() + this.getTestCaseUuid(this.currentTestCase.get()) + step.getHookType().toString() + step.getCodeLocation();
    }

    private String getHistoryId(TestCase testCase) {
        String testCaseLocation = testCase.getUri() + ":" + testCase.getLine();
        return ResultsUtils.md5((String)testCaseLocation);
    }

    private Status translateTestCaseStatus(Result testCaseResult) {
        switch (testCaseResult.getStatus()) {
            case FAILED: {
                return ResultsUtils.getStatus((Throwable)testCaseResult.getError()).orElse(Status.FAILED);
            }
            case PASSED: {
                return Status.PASSED;
            }
            case SKIPPED: 
            case PENDING: {
                return Status.SKIPPED;
            }
        }
        return null;
    }

    private List<Parameter> getExamplesAsParameters(ScenarioOutline scenarioOutline, TestCase localCurrentTestCase) {
        Optional<Examples> examplesBlock = scenarioOutline.getExamples().stream().filter(example -> example.getTableBody().stream().anyMatch(row -> row.getLocation().getLine() == localCurrentTestCase.getLine())).findFirst();
        if (examplesBlock.isPresent()) {
            TableRow row = examplesBlock.get().getTableBody().stream().filter(example -> example.getLocation().getLine() == localCurrentTestCase.getLine()).findFirst().get();
            return IntStream.range(0, examplesBlock.get().getTableHeader().getCells().size()).mapToObj(index -> {
                String name = ((TableCell)((Examples)examplesBlock.get()).getTableHeader().getCells().get(index)).getValue();
                String value = ((TableCell)row.getCells().get(index)).getValue();
                return ResultsUtils.createParameter((String)name, (Object)value);
            }).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    private void createDataTableAttachment(PickleTable pickleTable) {
        List rows = pickleTable.getRows();
        StringBuilder dataTableCsv = new StringBuilder();
        if (!rows.isEmpty()) {
            rows.forEach(dataTableRow -> {
                dataTableCsv.append(dataTableRow.getCells().stream().map(PickleCell::getValue).collect(Collectors.joining("\t")));
                dataTableCsv.append('\n');
            });
            String attachmentSource = this.lifecycle.prepareAttachment("Data table", "text/tab-separated-values", "csv");
            this.lifecycle.writeAttachment(attachmentSource, (InputStream)new ByteArrayInputStream(dataTableCsv.toString().getBytes(StandardCharsets.UTF_8)));
        }
    }

    private void handleHookStep(TestStepFinished event) {
        HookTestStep hookStep = (HookTestStep)event.testStep;
        String uuid = this.getHookStepUuid(hookStep);
        FixtureResult fixtureResult = new FixtureResult().setStatus(this.translateTestCaseStatus(event.result));
        if (!Status.PASSED.equals((Object)fixtureResult.getStatus())) {
            TestResult testResult = new TestResult().setStatus(this.translateTestCaseStatus(event.result));
            StatusDetails statusDetails = ResultsUtils.getStatusDetails((Throwable)event.result.getError()).orElseGet(StatusDetails::new);
            String errorMessage = event.result.getError() == null ? hookStep.getHookType().name() + " is failed." : hookStep.getHookType().name() + " is failed: " + event.result.getError().getLocalizedMessage();
            statusDetails.setMessage(errorMessage);
            if (hookStep.getHookType() == HookType.Before) {
                TagParser tagParser = new TagParser(this.currentFeature.get(), this.currentTestCase.get());
                statusDetails.setFlaky(tagParser.isFlaky()).setMuted(tagParser.isMuted()).setKnown(tagParser.isKnown());
                testResult.setStatus(Status.SKIPPED);
                this.updateTestCaseStatus(testResult.getStatus());
                this.forbidTestCaseStatusChange.set(true);
            } else {
                testResult.setStatus(Status.BROKEN);
                this.updateTestCaseStatus(testResult.getStatus());
            }
            fixtureResult.setStatusDetails(statusDetails);
        }
        this.lifecycle.updateFixture(uuid, result -> result.setStatus(fixtureResult.getStatus()).setStatusDetails(fixtureResult.getStatusDetails()));
        this.lifecycle.stopFixture(uuid);
    }

    private void handlePickleStep(TestStepFinished event) {
        StatusDetails statusDetails;
        Status stepStatus = this.translateTestCaseStatus(event.result);
        if (event.result.getStatus() == Result.Type.UNDEFINED) {
            this.updateTestCaseStatus(Status.PASSED);
            statusDetails = ResultsUtils.getStatusDetails((Throwable)new PendingException("TODO: implement me")).orElse(new StatusDetails());
            this.lifecycle.updateTestCase(this.getTestCaseUuid(this.currentTestCase.get()), scenarioResult -> scenarioResult.setStatusDetails(statusDetails));
        } else {
            statusDetails = ResultsUtils.getStatusDetails((Throwable)event.result.getError()).orElse(new StatusDetails());
            this.updateTestCaseStatus(stepStatus);
        }
        if (!Status.PASSED.equals((Object)stepStatus) && stepStatus != null) {
            this.forbidTestCaseStatusChange.set(true);
        }
        TagParser tagParser = new TagParser(this.currentFeature.get(), this.currentTestCase.get());
        statusDetails.setFlaky(tagParser.isFlaky()).setMuted(tagParser.isMuted()).setKnown(tagParser.isKnown());
        this.lifecycle.updateStep(this.getStepUuid((PickleStepTestStep)event.testStep), stepResult -> stepResult.setStatus(stepStatus).setStatusDetails(statusDetails));
        this.lifecycle.stopStep(this.getStepUuid((PickleStepTestStep)event.testStep));
    }

    private void updateTestCaseStatus(Status status) {
        if (!this.forbidTestCaseStatusChange.get().booleanValue()) {
            this.lifecycle.updateTestCase(this.getTestCaseUuid(this.currentTestCase.get()), result -> result.setStatus(status));
        }
    }
}

