/*
 * Decompiled with CFR 0.152.
 */
package io.qameta.allure.cucumber4jvm;

import cucumber.api.HookTestStep;
import cucumber.api.HookType;
import cucumber.api.PendingException;
import cucumber.api.PickleStepTestStep;
import cucumber.api.Result;
import cucumber.api.TestCase;
import cucumber.api.TestStep;
import cucumber.api.event.ConcurrentEventListener;
import cucumber.api.event.EventHandler;
import cucumber.api.event.EventPublisher;
import cucumber.api.event.TestCaseFinished;
import cucumber.api.event.TestCaseStarted;
import cucumber.api.event.TestSourceRead;
import cucumber.api.event.TestStepFinished;
import cucumber.api.event.TestStepStarted;
import cucumber.runtime.formatter.TestSourcesModelProxy;
import gherkin.ast.Examples;
import gherkin.ast.Feature;
import gherkin.ast.ScenarioDefinition;
import gherkin.ast.ScenarioOutline;
import gherkin.ast.TableCell;
import gherkin.ast.TableRow;
import gherkin.pickles.PickleCell;
import gherkin.pickles.PickleTable;
import gherkin.pickles.PickleTag;
import io.qameta.allure.Allure;
import io.qameta.allure.AllureLifecycle;
import io.qameta.allure.cucumber4jvm.LabelBuilder;
import io.qameta.allure.cucumber4jvm.TagParser;
import io.qameta.allure.model.Parameter;
import io.qameta.allure.model.Status;
import io.qameta.allure.model.StatusDetails;
import io.qameta.allure.model.StepResult;
import io.qameta.allure.model.TestResult;
import io.qameta.allure.util.ResultsUtils;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AllureCucumber4Jvm
implements ConcurrentEventListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(AllureCucumber4Jvm.class);
    private final AllureLifecycle lifecycle;
    private final ConcurrentHashMap<String, String> scenarioUuids = new ConcurrentHashMap();
    private final TestSourcesModelProxy testSources = new TestSourcesModelProxy();
    private final ThreadLocal<Feature> currentFeature = new InheritableThreadLocal<Feature>();
    private final ThreadLocal<String> currentFeatureFile = new InheritableThreadLocal<String>();
    private final ThreadLocal<TestCase> currentTestCase = new InheritableThreadLocal<TestCase>();
    private final EventHandler<TestSourceRead> featureStartedHandler = this::handleFeatureStartedHandler;
    private final EventHandler<TestCaseStarted> caseStartedHandler = this::handleTestCaseStarted;
    private final EventHandler<TestCaseFinished> caseFinishedHandler = this::handleTestCaseFinished;
    private final EventHandler<TestStepStarted> stepStartedHandler = this::handleTestStepStarted;
    private final EventHandler<TestStepFinished> stepFinishedHandler = this::handleTestStepFinished;

    public AllureCucumber4Jvm() {
        this(Allure.getLifecycle());
    }

    public AllureCucumber4Jvm(AllureLifecycle lifecycle) {
        this.lifecycle = lifecycle;
    }

    public void setEventPublisher(EventPublisher publisher) {
        publisher.registerHandlerFor(TestSourceRead.class, this.featureStartedHandler);
        publisher.registerHandlerFor(TestCaseStarted.class, this.caseStartedHandler);
        publisher.registerHandlerFor(TestCaseFinished.class, this.caseFinishedHandler);
        publisher.registerHandlerFor(TestStepStarted.class, this.stepStartedHandler);
        publisher.registerHandlerFor(TestStepFinished.class, this.stepFinishedHandler);
    }

    private void handleFeatureStartedHandler(TestSourceRead event) {
        this.testSources.addTestSourceReadEvent(event.uri, event);
    }

    private void handleTestCaseStarted(TestCaseStarted event) {
        String localCurrentFeatureFile = event.testCase.getUri();
        Feature localCurrentFeature = this.testSources.getFeature(localCurrentFeatureFile);
        TestCase localCurrentTestCase = event.testCase;
        this.currentFeatureFile.set(localCurrentFeatureFile);
        this.currentFeature.set(localCurrentFeature);
        this.currentTestCase.set(localCurrentTestCase);
        LinkedList<PickleTag> tags = new LinkedList<PickleTag>(localCurrentTestCase.getTags());
        LabelBuilder labelBuilder = new LabelBuilder(localCurrentFeature, localCurrentTestCase, tags);
        String name = localCurrentTestCase.getName();
        String featureName = localCurrentFeature.getName();
        TestResult result = new TestResult().setUuid(this.getTestCaseUuid(localCurrentTestCase)).setHistoryId(this.getHistoryId(localCurrentTestCase)).setFullName(String.format("%s: %s", featureName, name)).setName(name).setLabels(labelBuilder.getScenarioLabels()).setLinks(labelBuilder.getScenarioLinks());
        ScenarioDefinition scenarioDefinition = this.testSources.getScenarioDefinition(localCurrentFeatureFile, localCurrentTestCase.getLine());
        if (scenarioDefinition instanceof ScenarioOutline) {
            result.setParameters(this.getExamplesAsParameters((ScenarioOutline)scenarioDefinition, localCurrentTestCase));
        }
        if (localCurrentFeature.getDescription() != null && !localCurrentFeature.getDescription().isEmpty()) {
            result.setDescription(localCurrentFeature.getDescription());
        }
        this.lifecycle.scheduleTestCase(result);
        this.lifecycle.startTestCase(this.getTestCaseUuid(localCurrentTestCase));
    }

    private void handleTestCaseFinished(TestCaseFinished event) {
        String uuid = this.getTestCaseUuid(event.testCase);
        this.lifecycle.updateTestCase(uuid, testResult -> testResult.setStatus(this.translateTestCaseStatus(event.result)));
        Optional details = ResultsUtils.getStatusDetails((Throwable)event.result.getError());
        details.ifPresent(statusDetails -> this.lifecycle.updateTestCase(uuid, testResult -> testResult.setStatusDetails(statusDetails)));
        this.lifecycle.stopTestCase(uuid);
        this.lifecycle.writeTestCase(uuid);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void handleTestStepStarted(TestStepStarted event) {
        String localCurrentFeatureFile = this.currentFeatureFile.get();
        Feature localCurrentFeature = this.currentFeature.get();
        TestCase localCurrentTestCase = this.currentTestCase.get();
        if (Objects.nonNull(localCurrentFeatureFile) && Objects.nonNull(localCurrentFeature) && Objects.nonNull(localCurrentTestCase)) {
            if (event.testStep instanceof PickleStepTestStep) {
                PickleStepTestStep pickleStepTestStep = (PickleStepTestStep)event.testStep;
                String stepKeyword = Optional.ofNullable(this.testSources.getKeywordFromSource(localCurrentFeatureFile, pickleStepTestStep.getStepLine())).orElse("UNDEFINED");
                StepResult stepResult = new StepResult().setName(String.format("%s %s", stepKeyword, pickleStepTestStep.getPickleStep().getText())).setStart(Long.valueOf(System.currentTimeMillis()));
                this.lifecycle.startStep(this.getTestCaseUuid(localCurrentTestCase), this.getStepUuid(event.testStep, localCurrentFeature, localCurrentTestCase), stepResult);
                pickleStepTestStep.getStepArgument().stream().filter(PickleTable.class::isInstance).findFirst().ifPresent(table -> this.createDataTableAttachment((PickleTable)table));
                return;
            } else {
                if (!(event.testStep instanceof HookTestStep)) throw new IllegalStateException();
                HookTestStep hookTestStep = (HookTestStep)event.testStep;
                StepResult stepResult = new StepResult().setName(this.getHookStepName(hookTestStep)).setStart(Long.valueOf(System.currentTimeMillis()));
                this.lifecycle.startStep(this.getTestCaseUuid(localCurrentTestCase), this.getHookStepUuid(event.testStep, localCurrentFeature, localCurrentTestCase), stepResult);
            }
            return;
        } else {
            LOGGER.error("Current Feature File, Feature and/or Test Case were not defined. Skipping TestStepStarted event");
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void handleTestStepFinished(TestStepFinished event) {
        Feature localCurrentFeature = this.currentFeature.get();
        TestCase localCurrentTestCase = this.currentTestCase.get();
        if (Objects.nonNull(localCurrentFeature) && Objects.nonNull(localCurrentTestCase)) {
            if (event.testStep instanceof PickleStepTestStep) {
                this.handlePickleStep(event, localCurrentFeature, localCurrentTestCase);
                return;
            } else {
                if (!(event.testStep instanceof HookTestStep)) throw new IllegalStateException();
                this.handleHookStep(event, localCurrentFeature, localCurrentTestCase);
            }
            return;
        } else {
            LOGGER.error("Current Feature and/or Test Case were not defined. Skipping TestStepFinished event");
        }
    }

    private String getTestCaseUuid(TestCase testCase) {
        return this.scenarioUuids.computeIfAbsent(this.getHistoryId(testCase), it -> UUID.randomUUID().toString());
    }

    private String getStepUuid(TestStep step, Feature localCurrentFeature, TestCase localCurrentTestCase) {
        PickleStepTestStep pickleStep = (PickleStepTestStep)step;
        return localCurrentFeature.getName() + this.getTestCaseUuid(localCurrentTestCase) + pickleStep.getStepText() + pickleStep.getStepLine();
    }

    private String getHookStepUuid(TestStep step, Feature localCurrentFeature, TestCase localCurrentTestCase) {
        HookTestStep hookTestStep = (HookTestStep)step;
        return localCurrentFeature.getName() + this.getTestCaseUuid(localCurrentTestCase) + hookTestStep.getHookType().toString() + step.getCodeLocation();
    }

    private String getHookStepName(HookTestStep testStep) {
        return testStep.getHookType().toString() + ": " + testStep.getCodeLocation();
    }

    private String getHistoryId(TestCase testCase) {
        String testCaseLocation = testCase.getUri() + ":" + testCase.getLine();
        return ResultsUtils.md5((String)testCaseLocation);
    }

    private Status translateTestCaseStatus(Result testCaseResult) {
        switch (testCaseResult.getStatus()) {
            case FAILED: {
                return ResultsUtils.getStatus((Throwable)testCaseResult.getError()).orElse(Status.FAILED);
            }
            case PASSED: {
                return Status.PASSED;
            }
            case SKIPPED: 
            case PENDING: 
            case UNDEFINED: {
                return Status.SKIPPED;
            }
        }
        return Status.BROKEN;
    }

    private List<Parameter> getExamplesAsParameters(ScenarioOutline scenarioOutline, TestCase localCurrentTestCase) {
        Optional<Examples> examplesBlock = scenarioOutline.getExamples().stream().filter(example -> example.getTableBody().stream().anyMatch(row -> row.getLocation().getLine() == localCurrentTestCase.getLine())).findFirst();
        if (examplesBlock.isPresent()) {
            TableRow row = examplesBlock.get().getTableBody().stream().filter(example -> example.getLocation().getLine() == localCurrentTestCase.getLine()).findFirst().get();
            return IntStream.range(0, examplesBlock.get().getTableHeader().getCells().size()).mapToObj(index -> {
                String name = ((TableCell)((Examples)examplesBlock.get()).getTableHeader().getCells().get(index)).getValue();
                String value = ((TableCell)row.getCells().get(index)).getValue();
                return new Parameter().setName(name).setValue(value);
            }).collect(Collectors.toList());
        }
        LOGGER.error("Could not find matching Examples block. Returning empty parameters list");
        return Collections.emptyList();
    }

    private void createDataTableAttachment(PickleTable pickleTable) {
        List rows = pickleTable.getRows();
        StringBuilder dataTableCsv = new StringBuilder();
        if (!rows.isEmpty()) {
            rows.forEach(dataTableRow -> {
                dataTableCsv.append(dataTableRow.getCells().stream().map(PickleCell::getValue).collect(Collectors.joining("\t")));
                dataTableCsv.append('\n');
            });
            String attachmentSource = this.lifecycle.prepareAttachment("Data table", "text/tab-separated-values", "csv");
            this.lifecycle.writeAttachment(attachmentSource, (InputStream)new ByteArrayInputStream(dataTableCsv.toString().getBytes(Charset.forName("UTF-8"))));
        }
    }

    private void handleHookStep(TestStepFinished event, Feature localCurrentFeature, TestCase localCurrentTestCase) {
        String uuid = this.getHookStepUuid(event.testStep, localCurrentFeature, localCurrentTestCase);
        Status stepStatus = this.translateTestCaseStatus(event.result);
        Consumer<StepResult> stepResult = result -> result.setStatus(stepStatus);
        switch (stepStatus) {
            case FAILED: 
            case BROKEN: {
                StatusDetails statusDetails = ResultsUtils.getStatusDetails((Throwable)event.result.getError()).orElse(new StatusDetails());
                HookTestStep hookTestStep = (HookTestStep)event.testStep;
                if (hookTestStep.getHookType() == HookType.Before) {
                    TagParser tagParser = new TagParser(localCurrentFeature, localCurrentTestCase);
                    statusDetails.setMessage("Before is failed: " + statusDetails.getMessage()).setFlaky(tagParser.isFlaky()).setMuted(tagParser.isMuted()).setKnown(tagParser.isKnown());
                    this.lifecycle.updateTestCase(this.getTestCaseUuid(localCurrentTestCase), scenarioResult -> scenarioResult.setStatus(Status.SKIPPED).setStatusDetails(statusDetails));
                }
                stepResult = result -> result.setStatus(this.translateTestCaseStatus(event.result)).setStatusDetails(statusDetails);
                break;
            }
        }
        this.lifecycle.updateStep(uuid, stepResult);
        this.lifecycle.stopStep(uuid);
    }

    private void handlePickleStep(TestStepFinished event, Feature localCurrentFeature, TestCase localCurrentTestCase) {
        StatusDetails statusDetails;
        String uuid = this.getStepUuid(event.testStep, localCurrentFeature, localCurrentTestCase);
        if (event.result.getStatus() == Result.Type.UNDEFINED) {
            statusDetails = ResultsUtils.getStatusDetails((Throwable)new PendingException("TODO: implement me")).orElse(new StatusDetails());
            this.lifecycle.updateTestCase(this.getTestCaseUuid(localCurrentTestCase), scenarioResult -> scenarioResult.setStatus(this.translateTestCaseStatus(event.result)).setStatusDetails(statusDetails));
        } else {
            statusDetails = ResultsUtils.getStatusDetails((Throwable)event.result.getError()).orElse(new StatusDetails());
        }
        TagParser tagParser = new TagParser(localCurrentFeature, localCurrentTestCase);
        statusDetails.setFlaky(tagParser.isFlaky()).setMuted(tagParser.isMuted()).setKnown(tagParser.isKnown());
        this.lifecycle.updateStep(uuid, stepResult -> stepResult.setStatus(this.translateTestCaseStatus(event.result)));
        this.lifecycle.stopStep(uuid);
    }
}

