/*
 * Decompiled with CFR 0.152.
 */
package io.qameta.allure.cucumber6jvm.testsourcemodel;

import io.cucumber.gherkin.GherkinDialect;
import io.cucumber.gherkin.GherkinDialectProvider;
import io.cucumber.messages.Messages;
import io.cucumber.plugin.event.TestSourceRead;
import io.qameta.allure.cucumber6jvm.testsourcemodel.TestSourcesModel;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;

public class TestSourcesModelProxy {
    private final Map<URI, TestSourceRead> pathToReadEventMap = new HashMap<URI, TestSourceRead>();
    private final TestSourcesModel testSources = new TestSourcesModel();

    public void addTestSourceReadEvent(URI path, TestSourceRead event) {
        this.pathToReadEventMap.put(path, event);
        this.testSources.addTestSourceReadEvent(path, event);
    }

    public Messages.GherkinDocument.Feature getFeature(URI path) {
        return this.testSources.getFeature(path);
    }

    public Messages.GherkinDocument.Feature.Scenario getScenarioDefinition(URI path, int line) {
        return TestSourcesModel.getScenarioDefinition(this.testSources.getAstNode(path, line));
    }

    public String getKeywordFromSource(URI uri, int stepLine) {
        return this.getKeywordFromSourceInternal(uri, stepLine);
    }

    private String getKeywordFromSourceInternal(URI uri, int stepLine) {
        Messages.GherkinDocument.Feature feature = this.getFeature(uri);
        if (feature != null) {
            TestSourceRead event = this.getTestSourceReadEvent(uri);
            String trimmedSourceLine = event.getSource().split("\n")[stepLine - 1].trim();
            GherkinDialect dialect = new GherkinDialectProvider(feature.getLanguage()).getDefaultDialect();
            for (String keyword : dialect.getStepKeywords()) {
                if (!trimmedSourceLine.startsWith(keyword)) continue;
                return keyword;
            }
        }
        return "";
    }

    private TestSourceRead getTestSourceReadEvent(URI uri) {
        if (this.pathToReadEventMap.containsKey(uri)) {
            return this.pathToReadEventMap.get(uri);
        }
        return null;
    }
}

