/*
 * Decompiled with CFR 0.152.
 */
package io.qameta.allure.cucumber7jvm;

import io.cucumber.messages.types.Examples;
import io.cucumber.messages.types.Feature;
import io.cucumber.messages.types.Scenario;
import io.cucumber.messages.types.TableCell;
import io.cucumber.messages.types.TableRow;
import io.cucumber.plugin.ConcurrentEventListener;
import io.cucumber.plugin.event.DataTableArgument;
import io.cucumber.plugin.event.EmbedEvent;
import io.cucumber.plugin.event.EventHandler;
import io.cucumber.plugin.event.EventPublisher;
import io.cucumber.plugin.event.HookTestStep;
import io.cucumber.plugin.event.HookType;
import io.cucumber.plugin.event.PickleStepTestStep;
import io.cucumber.plugin.event.Result;
import io.cucumber.plugin.event.Step;
import io.cucumber.plugin.event.StepArgument;
import io.cucumber.plugin.event.TestCase;
import io.cucumber.plugin.event.TestCaseFinished;
import io.cucumber.plugin.event.TestCaseStarted;
import io.cucumber.plugin.event.TestSourceRead;
import io.cucumber.plugin.event.TestStepFinished;
import io.cucumber.plugin.event.TestStepStarted;
import io.cucumber.plugin.event.WriteEvent;
import io.qameta.allure.Allure;
import io.qameta.allure.AllureLifecycle;
import io.qameta.allure.cucumber7jvm.LabelBuilder;
import io.qameta.allure.cucumber7jvm.TagParser;
import io.qameta.allure.cucumber7jvm.testsourcemodel.TestSourcesModelProxy;
import io.qameta.allure.model.FixtureResult;
import io.qameta.allure.model.Parameter;
import io.qameta.allure.model.Status;
import io.qameta.allure.model.StatusDetails;
import io.qameta.allure.model.StepResult;
import io.qameta.allure.model.TestResult;
import io.qameta.allure.model.TestResultContainer;
import io.qameta.allure.util.ResultsUtils;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;

public class AllureCucumber7Jvm
implements ConcurrentEventListener {
    private static final String COLON = ":";
    private final AllureLifecycle lifecycle;
    private final TestSourcesModelProxy testSources = new TestSourcesModelProxy();
    private final EventHandler<TestSourceRead> featureStartedHandler = this::handleFeatureStartedHandler;
    private final EventHandler<TestCaseStarted> caseStartedHandler = this::handleTestCaseStarted;
    private final EventHandler<TestCaseFinished> caseFinishedHandler = this::handleTestCaseFinished;
    private final EventHandler<TestStepStarted> stepStartedHandler = this::handleTestStepStarted;
    private final EventHandler<TestStepFinished> stepFinishedHandler = this::handleTestStepFinished;
    private final EventHandler<WriteEvent> writeEventHandler = this::handleWriteEvent;
    private final EventHandler<EmbedEvent> embedEventHandler = this::handleEmbedEvent;
    private final Map<UUID, String> hookStepContainerUuid = new ConcurrentHashMap<UUID, String>();
    private static final String TXT_EXTENSION = ".txt";
    private static final String TEXT_PLAIN = "text/plain";
    private static final String CUCUMBER_WORKING_DIR = Paths.get("", new String[0]).toUri().getSchemeSpecificPart();

    public AllureCucumber7Jvm() {
        this(Allure.getLifecycle());
    }

    public AllureCucumber7Jvm(AllureLifecycle lifecycle) {
        this.lifecycle = lifecycle;
    }

    public void setEventPublisher(EventPublisher publisher) {
        publisher.registerHandlerFor(TestSourceRead.class, this.featureStartedHandler);
        publisher.registerHandlerFor(TestCaseStarted.class, this.caseStartedHandler);
        publisher.registerHandlerFor(TestCaseFinished.class, this.caseFinishedHandler);
        publisher.registerHandlerFor(TestStepStarted.class, this.stepStartedHandler);
        publisher.registerHandlerFor(TestStepFinished.class, this.stepFinishedHandler);
        publisher.registerHandlerFor(WriteEvent.class, this.writeEventHandler);
        publisher.registerHandlerFor(EmbedEvent.class, this.embedEventHandler);
    }

    private void handleFeatureStartedHandler(TestSourceRead event) {
        this.testSources.addTestSourceReadEvent(event.getUri(), event);
    }

    private void handleTestCaseStarted(TestCaseStarted event) {
        String description;
        TestCase testCase = event.getTestCase();
        Feature feature = this.testSources.getFeature(testCase.getUri());
        LinkedList<String> tags = new LinkedList<String>(testCase.getTags());
        LabelBuilder labelBuilder = new LabelBuilder(feature, testCase, tags);
        String name = testCase.getName();
        String fullName = String.format("%s:%d", this.getTestCaseUri(testCase), testCase.getLocation().getLine());
        String testCaseUuid = testCase.getId().toString();
        TestResult result = new TestResult().setUuid(testCaseUuid).setTestCaseId(this.getTestCaseId(testCase)).setHistoryId(this.getHistoryId(testCase)).setFullName(fullName).setName(name).setLabels(labelBuilder.getScenarioLabels()).setLinks(labelBuilder.getScenarioLinks());
        Scenario scenarioDefinition = this.testSources.getScenarioDefinition(testCase.getUri(), testCase.getLocation().getLine());
        if (scenarioDefinition.getExamples() != null) {
            result.setParameters(this.getExamplesAsParameters(scenarioDefinition, testCase));
        }
        if (!(description = Stream.of(feature.getDescription(), scenarioDefinition.getDescription()).filter(Objects::nonNull).filter(s -> !s.isEmpty()).collect(Collectors.joining("\n"))).isEmpty()) {
            result.setDescription(description);
        }
        this.lifecycle.scheduleTestCase(result);
        this.lifecycle.startTestCase(testCaseUuid);
    }

    private void handleTestCaseFinished(TestCaseFinished event) {
        TestCase testCase = event.getTestCase();
        Feature feature = this.testSources.getFeature(testCase.getUri());
        String uuid = testCase.getId().toString();
        Result result = event.getResult();
        Status status = this.translateTestCaseStatus(result);
        StatusDetails statusDetails = ResultsUtils.getStatusDetails((Throwable)result.getError()).orElseGet(StatusDetails::new);
        TagParser tagParser = new TagParser(feature, testCase);
        statusDetails.setFlaky(tagParser.isFlaky()).setMuted(tagParser.isMuted()).setKnown(tagParser.isKnown());
        this.lifecycle.updateTestCase(uuid, testResult -> testResult.setStatus(status).setStatusDetails(statusDetails));
        this.lifecycle.stopTestCase(uuid);
        this.lifecycle.writeTestCase(uuid);
    }

    private void handleTestStepStarted(TestStepStarted event) {
        TestCase testCase = event.getTestCase();
        if (event.getTestStep() instanceof HookTestStep) {
            HookTestStep hook = (HookTestStep)event.getTestStep();
            if (AllureCucumber7Jvm.isFixtureHook(hook)) {
                this.handleStartFixtureHook(testCase, hook);
            } else {
                this.handleStartStepHook(testCase, hook);
            }
        } else if (event.getTestStep() instanceof PickleStepTestStep) {
            this.handleStartPickleStep(testCase, (PickleStepTestStep)event.getTestStep());
        }
    }

    private void handleStartPickleStep(TestCase testCase, PickleStepTestStep pickleStep) {
        String uuid = testCase.getId().toString();
        Step step = pickleStep.getStep();
        StepResult stepResult = new StepResult().setName(step.getKeyword() + step.getText()).setStart(Long.valueOf(System.currentTimeMillis()));
        this.lifecycle.setCurrentTestCase(uuid);
        this.lifecycle.startStep(uuid, pickleStep.getId().toString(), stepResult);
        StepArgument stepArgument = step.getArgument();
        if (stepArgument instanceof DataTableArgument) {
            DataTableArgument dataTableArgument = (DataTableArgument)stepArgument;
            this.createDataTableAttachment(dataTableArgument);
        }
    }

    private void handleStartStepHook(TestCase testCase, HookTestStep hook) {
        String uuid = testCase.getId().toString();
        StepResult stepResult = new StepResult().setName(hook.getCodeLocation()).setStart(Long.valueOf(System.currentTimeMillis()));
        this.lifecycle.setCurrentTestCase(uuid);
        this.lifecycle.startStep(uuid, hook.getId().toString(), stepResult);
    }

    private void handleStartFixtureHook(TestCase testCase, HookTestStep hook) {
        String uuid = testCase.getId().toString();
        UUID hookId = hook.getId();
        String containerUuid = this.hookStepContainerUuid.computeIfAbsent(hookId, unused -> UUID.randomUUID().toString());
        this.lifecycle.startTestContainer(new TestResultContainer().setUuid(containerUuid).setChildren(Collections.singletonList(uuid)));
        FixtureResult hookResult = new FixtureResult().setName(hook.getCodeLocation());
        String fixtureUuid = hookId.toString();
        if (hook.getHookType() == HookType.BEFORE) {
            this.lifecycle.startPrepareFixture(containerUuid, fixtureUuid, hookResult);
        } else {
            this.lifecycle.startTearDownFixture(containerUuid, fixtureUuid, hookResult);
        }
    }

    private void handleTestStepFinished(TestStepFinished event) {
        if (event.getTestStep() instanceof HookTestStep) {
            HookTestStep hook = (HookTestStep)event.getTestStep();
            if (AllureCucumber7Jvm.isFixtureHook(hook)) {
                this.handleStopHookStep(event.getResult(), hook);
            } else {
                this.handleStopStep(event.getTestCase(), event.getResult(), hook.getId());
            }
        } else if (event.getTestStep() instanceof PickleStepTestStep) {
            PickleStepTestStep pickleStep = (PickleStepTestStep)event.getTestStep();
            this.handleStopStep(event.getTestCase(), event.getResult(), pickleStep.getId());
        }
    }

    private static boolean isFixtureHook(HookTestStep hook) {
        return hook.getHookType() == HookType.BEFORE || hook.getHookType() == HookType.AFTER;
    }

    private void handleWriteEvent(WriteEvent event) {
        this.lifecycle.addAttachment("Text output", TEXT_PLAIN, TXT_EXTENSION, Objects.toString(event.getText()).getBytes(StandardCharsets.UTF_8));
    }

    private void handleEmbedEvent(EmbedEvent event) {
        this.lifecycle.addAttachment(event.name, event.getMediaType(), null, (InputStream)new ByteArrayInputStream(event.getData()));
    }

    private String getHistoryId(TestCase testCase) {
        String testCaseLocation = this.getTestCaseUri(testCase) + COLON + testCase.getLocation().getLine();
        return ResultsUtils.md5((String)testCaseLocation);
    }

    private String getTestCaseId(TestCase testCase) {
        String testCaseId = this.getTestCaseUri(testCase) + COLON + testCase.getName();
        return ResultsUtils.md5((String)testCaseId);
    }

    private String getTestCaseUri(TestCase testCase) {
        String testCaseUri = testCase.getUri().getSchemeSpecificPart();
        if (testCaseUri.startsWith(CUCUMBER_WORKING_DIR)) {
            return testCaseUri.substring(CUCUMBER_WORKING_DIR.length());
        }
        return testCaseUri;
    }

    private Status translateTestCaseStatus(Result testCaseResult) {
        switch (testCaseResult.getStatus()) {
            case FAILED: {
                return ResultsUtils.getStatus((Throwable)testCaseResult.getError()).orElse(Status.FAILED);
            }
            case PASSED: {
                return Status.PASSED;
            }
            case SKIPPED: 
            case PENDING: {
                return Status.SKIPPED;
            }
        }
        return null;
    }

    private List<Parameter> getExamplesAsParameters(Scenario scenario, TestCase localCurrentTestCase) {
        Optional<Examples> maybeExample = scenario.getExamples().stream().filter(example -> example.getTableBody().stream().anyMatch(row -> row.getLocation().getLine() == (long)localCurrentTestCase.getLocation().getLine())).findFirst();
        if (!maybeExample.isPresent()) {
            return Collections.emptyList();
        }
        Examples examples = maybeExample.get();
        Optional<TableRow> maybeRow = examples.getTableBody().stream().filter(example -> example.getLocation().getLine() == (long)localCurrentTestCase.getLocation().getLine()).findFirst();
        if (!maybeRow.isPresent()) {
            return Collections.emptyList();
        }
        TableRow row = maybeRow.get();
        int size = row.getCells().size();
        List headerNames = examples.getTableHeader().map(TableRow::getCells).map(rows -> rows.stream().map(TableCell::getValue).collect(Collectors.toList())).orElse(null);
        return IntStream.range(0, size).mapToObj(index -> {
            String name = Objects.nonNull(headerNames) ? (String)headerNames.get(index) : "arg" + index;
            String value = ((TableCell)row.getCells().get(index)).getValue();
            return ResultsUtils.createParameter((String)name, (Object)value);
        }).collect(Collectors.toList());
    }

    private void createDataTableAttachment(DataTableArgument dataTableArgument) {
        List rowsInTable = dataTableArgument.cells();
        StringBuilder dataTableCsv = new StringBuilder();
        for (List columns : rowsInTable) {
            if (columns.isEmpty()) continue;
            for (int i = 0; i < columns.size(); ++i) {
                if (i == columns.size() - 1) {
                    dataTableCsv.append((String)columns.get(i));
                    continue;
                }
                dataTableCsv.append((String)columns.get(i));
                dataTableCsv.append('\t');
            }
            dataTableCsv.append('\n');
        }
        String attachmentSource = this.lifecycle.prepareAttachment("Data table", "text/tab-separated-values", "csv");
        this.lifecycle.writeAttachment(attachmentSource, (InputStream)new ByteArrayInputStream(dataTableCsv.toString().getBytes(StandardCharsets.UTF_8)));
    }

    private void handleStopHookStep(Result eventResult, HookTestStep hook) {
        String containerUuid = this.hookStepContainerUuid.get(hook.getId());
        if (Objects.isNull(containerUuid)) {
            return;
        }
        String uuid = hook.getId().toString();
        Status status = this.translateTestCaseStatus(eventResult);
        StatusDetails statusDetails = ResultsUtils.getStatusDetails((Throwable)eventResult.getError()).orElseGet(StatusDetails::new);
        this.lifecycle.updateFixture(uuid, result -> result.setStatus(status).setStatusDetails(statusDetails));
        this.lifecycle.stopFixture(uuid);
        this.lifecycle.stopTestContainer(containerUuid);
        this.lifecycle.writeTestContainer(containerUuid);
    }

    private void handleStopStep(TestCase testCase, Result eventResult, UUID stepId) {
        Feature feature = this.testSources.getFeature(testCase.getUri());
        Status stepStatus = this.translateTestCaseStatus(eventResult);
        StatusDetails statusDetails = eventResult.getStatus() == io.cucumber.plugin.event.Status.UNDEFINED ? new StatusDetails().setMessage("Undefined Step. Please add step definition") : ResultsUtils.getStatusDetails((Throwable)eventResult.getError()).orElse(new StatusDetails());
        TagParser tagParser = new TagParser(feature, testCase);
        statusDetails.setFlaky(tagParser.isFlaky()).setMuted(tagParser.isMuted()).setKnown(tagParser.isKnown());
        String stepUuid = stepId.toString();
        this.lifecycle.updateStep(stepUuid, stepResult -> stepResult.setStatus(stepStatus).setStatusDetails(statusDetails));
        this.lifecycle.stopStep(stepUuid);
    }
}

