/*
 * Decompiled with CFR 0.152.
 */
package io.qameta.allure.cucumber7jvm.testsourcemodel;

import io.cucumber.gherkin.GherkinParser;
import io.cucumber.messages.types.Background;
import io.cucumber.messages.types.Envelope;
import io.cucumber.messages.types.Examples;
import io.cucumber.messages.types.Feature;
import io.cucumber.messages.types.FeatureChild;
import io.cucumber.messages.types.GherkinDocument;
import io.cucumber.messages.types.RuleChild;
import io.cucumber.messages.types.Scenario;
import io.cucumber.messages.types.Source;
import io.cucumber.messages.types.SourceMediaType;
import io.cucumber.messages.types.Step;
import io.cucumber.messages.types.TableRow;
import io.cucumber.plugin.event.TestSourceRead;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;

final class TestSourcesModel {
    private final Map<URI, TestSourceRead> pathToReadEventMap = new HashMap<URI, TestSourceRead>();
    private final Map<URI, GherkinDocument> pathToAstMap = new HashMap<URI, GherkinDocument>();
    private final Map<URI, Map<Long, AstNode>> pathToNodeMap = new HashMap<URI, Map<Long, AstNode>>();

    TestSourcesModel() {
    }

    public static Scenario getScenarioDefinition(AstNode astNode) {
        AstNode candidate = astNode;
        while (candidate != null && !(candidate.node instanceof Scenario)) {
            candidate = candidate.parent;
        }
        return candidate == null ? null : (Scenario)candidate.node;
    }

    public void addTestSourceReadEvent(URI path, TestSourceRead event) {
        this.pathToReadEventMap.put(path, event);
    }

    public Feature getFeature(URI path) {
        if (!this.pathToAstMap.containsKey(path)) {
            this.parseGherkinSource(path);
        }
        if (this.pathToAstMap.containsKey(path)) {
            return this.pathToAstMap.get(path).getFeature().orElse(null);
        }
        return null;
    }

    private void parseGherkinSource(URI path) {
        if (!this.pathToReadEventMap.containsKey(path)) {
            return;
        }
        String source = this.pathToReadEventMap.get(path).getSource();
        GherkinParser parser = GherkinParser.builder().build();
        Stream envelopes = parser.parse(Envelope.of((Source)new Source(path.toString(), source, SourceMediaType.TEXT_X_CUCUMBER_GHERKIN_PLAIN)));
        GherkinDocument gherkinDocument = envelopes.map(Envelope::getGherkinDocument).filter(Optional::isPresent).map(Optional::get).findFirst().orElse(null);
        this.pathToAstMap.put(path, gherkinDocument);
        HashMap<Long, AstNode> nodeMap = new HashMap<Long, AstNode>();
        Feature feature = (Feature)gherkinDocument.getFeature().get();
        AstNode currentParent = new AstNode(feature, null);
        for (FeatureChild child : feature.getChildren()) {
            this.processFeatureDefinition(nodeMap, child, currentParent);
        }
        this.pathToNodeMap.put(path, nodeMap);
    }

    private void processFeatureDefinition(Map<Long, AstNode> nodeMap, FeatureChild child, AstNode currentParent) {
        child.getBackground().ifPresent(background -> this.processBackgroundDefinition(nodeMap, (Background)background, currentParent));
        child.getScenario().ifPresent(scenario -> this.processScenarioDefinition(nodeMap, (Scenario)scenario, currentParent));
        child.getRule().ifPresent(rule -> {
            AstNode childNode = new AstNode(rule, currentParent);
            nodeMap.put(rule.getLocation().getLine(), childNode);
            rule.getChildren().forEach(ruleChild -> this.processRuleDefinition(nodeMap, (RuleChild)ruleChild, childNode));
        });
    }

    private void processBackgroundDefinition(Map<Long, AstNode> nodeMap, Background background, AstNode currentParent) {
        AstNode childNode = this.createAstNode(background, currentParent);
        nodeMap.put(background.getLocation().getLine(), childNode);
        for (Step step : background.getSteps()) {
            nodeMap.put(step.getLocation().getLine(), this.createAstNode(step, childNode));
        }
    }

    private void processScenarioDefinition(Map<Long, AstNode> nodeMap, Scenario child, AstNode currentParent) {
        AstNode childNode = this.createAstNode(child, currentParent);
        nodeMap.put(child.getLocation().getLine(), childNode);
        for (Step step : child.getSteps()) {
            nodeMap.put(step.getLocation().getLine(), this.createAstNode(step, childNode));
        }
        if (child.getExamples().size() > 0) {
            this.processScenarioOutlineExamples(nodeMap, child, childNode);
        }
    }

    private void processRuleDefinition(Map<Long, AstNode> nodeMap, RuleChild child, AstNode currentParent) {
        child.getBackground().ifPresent(background -> this.processBackgroundDefinition(nodeMap, (Background)background, currentParent));
        child.getScenario().ifPresent(scenario -> this.processScenarioDefinition(nodeMap, (Scenario)scenario, currentParent));
    }

    private void processScenarioOutlineExamples(Map<Long, AstNode> nodeMap, Scenario scenarioOutline, AstNode parent) {
        for (Examples examples : scenarioOutline.getExamples()) {
            AstNode examplesNode = this.createAstNode(examples, parent);
            TableRow headerRow = (TableRow)examples.getTableHeader().get();
            AstNode headerNode = this.createAstNode(headerRow, examplesNode);
            nodeMap.put(headerRow.getLocation().getLine(), headerNode);
            for (int i = 0; i < examples.getTableBody().size(); ++i) {
                TableRow examplesRow = (TableRow)examples.getTableBody().get(i);
                AstNode expandedScenarioNode = this.createAstNode(examplesRow, examplesNode);
                nodeMap.put(examplesRow.getLocation().getLine(), expandedScenarioNode);
            }
        }
    }

    public AstNode getAstNode(URI path, int line) {
        if (!this.pathToNodeMap.containsKey(path)) {
            this.parseGherkinSource(path);
        }
        if (this.pathToNodeMap.containsKey(path)) {
            return this.pathToNodeMap.get(path).get(line);
        }
        return null;
    }

    private AstNode createAstNode(Object node, AstNode astNode) {
        return new AstNode(node, astNode);
    }

    private static class AstNode {
        private final Object node;
        private final AstNode parent;

        AstNode(Object node, AstNode parent) {
            this.node = node;
            this.parent = parent;
        }
    }
}

