/*
 * Decompiled with CFR 0.152.
 */
package io.qameta.allure.cucumber7jvm;

import io.cucumber.messages.types.Feature;
import io.cucumber.plugin.event.TestCase;
import io.qameta.allure.cucumber7jvm.TagParser;
import io.qameta.allure.model.Label;
import io.qameta.allure.model.Link;
import io.qameta.allure.util.ResultsUtils;
import java.io.File;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Deque;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class LabelBuilder {
    private static final Logger LOGGER = LoggerFactory.getLogger(LabelBuilder.class);
    private static final String COMPOSITE_TAG_DELIMITER = "=";
    private static final String SEVERITY = "@SEVERITY";
    private static final String ISSUE_LINK = "@ISSUE";
    private static final String TMS_LINK = "@TMSLINK";
    private static final String PLAIN_LINK = "@LINK";
    private static final String OWNER = "@OWNER";
    private final List<Label> scenarioLabels = new ArrayList<Label>();
    private final List<Link> scenarioLinks = new ArrayList<Link>();

    LabelBuilder(Feature feature, TestCase scenario, Deque<String> tags) {
        TagParser tagParser = new TagParser(feature, scenario);
        while (tags.peek() != null) {
            String tag = tags.remove();
            if (tag.contains(COMPOSITE_TAG_DELIMITER)) {
                String[] tagParts = tag.split(COMPOSITE_TAG_DELIMITER, 2);
                if (tagParts.length < 2 || Objects.isNull(tagParts[1]) || tagParts[1].isEmpty()) continue;
                String tagKey = tagParts[0].toUpperCase();
                String tagValue = tagParts[1];
                if (tagKey.startsWith("@LINK.")) {
                    this.tryHandleNamedLink(tag);
                    continue;
                }
                switch (tagKey) {
                    case "@SEVERITY": {
                        this.scenarioLabels.add(ResultsUtils.createSeverityLabel((String)tagValue.toLowerCase()));
                        break;
                    }
                    case "@TMSLINK": {
                        this.scenarioLinks.add(ResultsUtils.createTmsLink((String)tagValue));
                        break;
                    }
                    case "@ISSUE": {
                        this.scenarioLinks.add(ResultsUtils.createIssueLink((String)tagValue));
                        break;
                    }
                    case "@LINK": {
                        this.scenarioLinks.add(ResultsUtils.createLink(null, (String)tagValue, (String)tagValue, null));
                        break;
                    }
                    case "@OWNER": {
                        this.scenarioLabels.add(ResultsUtils.createOwnerLabel((String)tagValue));
                        break;
                    }
                    default: {
                        LOGGER.warn("Composite tag {} is not supported. adding it as RAW", (Object)tagKey);
                        this.scenarioLabels.add(this.getTagLabel(tag));
                        break;
                    }
                }
                continue;
            }
            if (tagParser.isPureSeverityTag(tag)) {
                this.scenarioLabels.add(ResultsUtils.createSeverityLabel((String)tag.substring(1)));
                continue;
            }
            if (tagParser.isResultTag(tag)) continue;
            this.scenarioLabels.add(this.getTagLabel(tag));
        }
        String featureName = feature.getName();
        URI uri = scenario.getUri();
        this.scenarioLabels.addAll(ResultsUtils.getProvidedLabels());
        this.scenarioLabels.addAll(Arrays.asList(ResultsUtils.createHostLabel(), ResultsUtils.createThreadLabel(), ResultsUtils.createFeatureLabel((String)featureName), ResultsUtils.createStoryLabel((String)scenario.getName()), ResultsUtils.createSuiteLabel((String)featureName), ResultsUtils.createTestClassLabel((String)scenario.getName()), ResultsUtils.createFrameworkLabel((String)"cucumber4jvm"), ResultsUtils.createLanguageLabel((String)"java"), ResultsUtils.createLabel((String)"gherkin_uri", (String)uri.toString())));
        this.featurePackage(uri.toString(), featureName).map(ResultsUtils::createPackageLabel).ifPresent(this.scenarioLabels::add);
    }

    public List<Label> getScenarioLabels() {
        return this.scenarioLabels;
    }

    public List<Link> getScenarioLinks() {
        return this.scenarioLinks;
    }

    private Label getTagLabel(String tag) {
        return ResultsUtils.createTagLabel((String)tag.substring(1));
    }

    private void tryHandleNamedLink(String tagString) {
        String namedLinkPatternString = "@LINK\\.(\\w+-?)+=(\\w+([-_])?)+";
        Pattern namedLinkPattern = Pattern.compile("@LINK\\.(\\w+-?)+=(\\w+([-_])?)+", 2);
        if (namedLinkPattern.matcher(tagString).matches()) {
            String type = tagString.split(COMPOSITE_TAG_DELIMITER)[0].split("[.]")[1];
            String name = tagString.split(COMPOSITE_TAG_DELIMITER)[1];
            this.scenarioLinks.add(ResultsUtils.createLink(null, (String)name, null, (String)type));
        } else {
            LOGGER.warn("Composite named tag {} does not match regex {}. Skipping", (Object)tagString, (Object)"@LINK\\.(\\w+-?)+=(\\w+([-_])?)+");
        }
    }

    private Optional<String> featurePackage(String uriString, String featureName) {
        Optional<URI> maybeUri = LabelBuilder.safeUri(uriString);
        if (!maybeUri.isPresent()) {
            return Optional.empty();
        }
        URI uri = maybeUri.get();
        if (!uri.isOpaque()) {
            URI work = new File("").toURI();
            uri = work.relativize(uri);
        }
        String schemeSpecificPart = uri.normalize().getSchemeSpecificPart();
        Stream<String> folders = Stream.of(schemeSpecificPart.replaceAll("\\.", "_").split("/"));
        Stream<String> name = Stream.of(featureName);
        return Optional.of(Stream.concat(folders, name).filter(Objects::nonNull).filter(s -> !s.isEmpty()).collect(Collectors.joining(".")));
    }

    private static Optional<URI> safeUri(String uri) {
        try {
            return Optional.of(URI.create(uri));
        }
        catch (Exception e) {
            LOGGER.debug("could not parse feature uri {}", (Object)uri, (Object)e);
            return Optional.empty();
        }
    }
}

