/*
 * Decompiled with CFR 0.152.
 */
package io.qameta.allure.descriptions;

import io.qameta.allure.Description;
import io.qameta.allure.util.ResultsUtils;
import java.io.IOException;
import java.io.Writer;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.Filer;
import javax.annotation.processing.Messager;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.annotation.processing.SupportedSourceVersion;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.util.Elements;
import javax.tools.Diagnostic;
import javax.tools.FileObject;
import javax.tools.StandardLocation;

@SupportedAnnotationTypes(value={"io.qameta.allure.Description"})
@SupportedSourceVersion(value=SourceVersion.RELEASE_8)
public class DescriptionsProcessor
extends AbstractProcessor {
    private Filer filer;
    private Elements elementUtils;
    private Messager messager;

    @Override
    public synchronized void init(ProcessingEnvironment env) {
        super.init(env);
        this.filer = env.getFiler();
        this.elementUtils = env.getElementUtils();
        this.messager = env.getMessager();
    }

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment env) {
        Set<? extends Element> elements = env.getElementsAnnotatedWith(Description.class);
        elements.forEach(el -> {
            if (!el.getAnnotation(Description.class).useJavaDoc()) {
                return;
            }
            String docs = this.elementUtils.getDocComment((Element)el);
            List typeParams = ((ExecutableElement)el).getParameters().stream().map(param -> param.asType().toString()).collect(Collectors.toList());
            String name = el.getSimpleName().toString();
            String hash = ResultsUtils.generateMethodSignatureHash((String)el.getEnclosingElement().toString(), (String)name, typeParams);
            try {
                FileObject file = this.filer.createResource(StandardLocation.CLASS_OUTPUT, "allureDescriptions", hash, new Element[0]);
                try (Writer writer = file.openWriter();){
                    writer.write(docs);
                }
            }
            catch (IOException e) {
                this.messager.printMessage(Diagnostic.Kind.WARNING, "Unable to create resource from docs comment of method " + name + typeParams);
            }
        });
        return true;
    }
}

