/*
 * Decompiled with CFR 0.152.
 */
package io.qameta.allure.launch;

import io.qameta.allure.CommonJsonAggregator;
import io.qameta.allure.Reader;
import io.qameta.allure.context.JacksonContext;
import io.qameta.allure.core.Configuration;
import io.qameta.allure.core.LaunchResults;
import io.qameta.allure.core.ResultsVisitor;
import io.qameta.allure.entity.Statistic;
import io.qameta.allure.launch.LaunchInfo;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;

public class LaunchPlugin
extends CommonJsonAggregator
implements Reader {
    private static final String LAUNCH_BLOCK_NAME = "launch";
    private static final String JSON_FILE_NAME = "launch.json";

    public LaunchPlugin() {
        super("widgets", JSON_FILE_NAME);
    }

    public void readResults(Configuration configuration, ResultsVisitor visitor, Path directory) {
        JacksonContext context = (JacksonContext)configuration.requireContext(JacksonContext.class);
        Path executorFile = directory.resolve(JSON_FILE_NAME);
        if (Files.exists(executorFile, new LinkOption[0])) {
            try (InputStream is = Files.newInputStream(executorFile, new OpenOption[0]);){
                LaunchInfo info = (LaunchInfo)context.getValue().readValue(is, LaunchInfo.class);
                visitor.visitExtra(LAUNCH_BLOCK_NAME, (Object)info);
            }
            catch (IOException e) {
                visitor.error("Could not read launch file " + executorFile, (Exception)e);
            }
        }
    }

    public List<LaunchInfo> getData(List<LaunchResults> launches) {
        return launches.stream().map(this::updateLaunchInfo).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList());
    }

    private Optional<LaunchInfo> updateLaunchInfo(LaunchResults results) {
        Optional extra = results.getExtra(LAUNCH_BLOCK_NAME);
        extra.map(launchInfo -> {
            Statistic statistic = new Statistic();
            launchInfo.setStatistic(statistic);
            results.getResults().forEach(arg_0 -> ((Statistic)statistic).update(arg_0));
            return launchInfo;
        });
        return extra;
    }
}

