/*
 * Decompiled with CFR 0.152.
 */
package io.qameta.allure.executor;

import io.qameta.allure.CommonJsonAggregator;
import io.qameta.allure.Reader;
import io.qameta.allure.context.JacksonContext;
import io.qameta.allure.core.Configuration;
import io.qameta.allure.core.LaunchResults;
import io.qameta.allure.core.ResultsVisitor;
import io.qameta.allure.entity.ExecutorInfo;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;

public class ExecutorPlugin
extends CommonJsonAggregator
implements Reader {
    public static final String EXECUTORS_BLOCK_NAME = "executor";
    protected static final String JSON_FILE_NAME = "executor.json";

    public ExecutorPlugin() {
        super("widgets", "executors.json");
    }

    public void readResults(Configuration configuration, ResultsVisitor visitor, Path directory) {
        JacksonContext context = (JacksonContext)configuration.requireContext(JacksonContext.class);
        Path executorFile = directory.resolve(JSON_FILE_NAME);
        if (Files.exists(executorFile, new LinkOption[0])) {
            try (InputStream is = Files.newInputStream(executorFile, new OpenOption[0]);){
                ExecutorInfo info = (ExecutorInfo)context.getValue().readValue(is, ExecutorInfo.class);
                visitor.visitExtra(EXECUTORS_BLOCK_NAME, (Object)info);
            }
            catch (IOException e) {
                visitor.error("Could not read executor file " + executorFile, (Exception)e);
            }
        }
    }

    protected List<ExecutorInfo> getData(List<LaunchResults> launches) {
        return launches.stream().map(launchResults -> launchResults.getExtra(EXECUTORS_BLOCK_NAME)).filter(Optional::isPresent).map(Optional::get).filter(ExecutorInfo.class::isInstance).map(ExecutorInfo.class::cast).collect(Collectors.toList());
    }
}

