/*
 * Decompiled with CFR 0.152.
 */
package io.qameta.allure.allure2;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.qameta.allure.Reader;
import io.qameta.allure.context.RandomUidContext;
import io.qameta.allure.core.Configuration;
import io.qameta.allure.core.ResultsVisitor;
import io.qameta.allure.entity.LabelName;
import io.qameta.allure.entity.Parameter;
import io.qameta.allure.entity.StageResult;
import io.qameta.allure.entity.Status;
import io.qameta.allure.entity.Step;
import io.qameta.allure.entity.Time;
import io.qameta.allure.model.Attachment;
import io.qameta.allure.model.FixtureResult;
import io.qameta.allure.model.Label;
import io.qameta.allure.model.Link;
import io.qameta.allure.model.Parameter;
import io.qameta.allure.model.StepResult;
import io.qameta.allure.model.TestResult;
import io.qameta.allure.model.TestResultContainer;
import io.qameta.allure.util.ConvertUtils;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Allure2Plugin
implements Reader {
    public static final String ALLURE2_RESULTS_FORMAT = "allure2";
    private static final Logger LOGGER = LoggerFactory.getLogger(Allure2Plugin.class);
    private static final Comparator<StageResult> BY_START = Comparator.comparing(StageResult::getTime, Comparator.nullsLast(Comparator.comparing(Time::getStart, Comparator.nullsLast(Comparator.naturalOrder()))));
    private final ObjectMapper mapper = new ObjectMapper().enable(new MapperFeature[]{MapperFeature.USE_WRAPPER_NAME_AS_PROPERTY_NAME}).enable(new MapperFeature[]{MapperFeature.ACCEPT_CASE_INSENSITIVE_ENUMS}).enable(new MapperFeature[]{MapperFeature.ACCEPT_CASE_INSENSITIVE_PROPERTIES}).enable(DeserializationFeature.READ_UNKNOWN_ENUM_VALUES_AS_NULL).disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES).disable(DeserializationFeature.FAIL_ON_IGNORED_PROPERTIES).disable(DeserializationFeature.FAIL_ON_NULL_FOR_PRIMITIVES).disable(DeserializationFeature.FAIL_ON_NUMBERS_FOR_ENUMS);

    public void readResults(Configuration configuration, ResultsVisitor visitor, Path resultsDirectory) {
        RandomUidContext context = (RandomUidContext)configuration.requireContext(RandomUidContext.class);
        List groups = this.readTestResultsContainers(resultsDirectory).collect(Collectors.toList());
        this.readTestResults(resultsDirectory).forEach(result -> this.convert(context.getValue(), resultsDirectory, visitor, groups, (TestResult)result));
    }

    private void convert(Supplier<String> uidGenerator, Path resultsDirectory, ResultsVisitor visitor, List<TestResultContainer> groups, TestResult result) {
        io.qameta.allure.entity.TestResult dest = new io.qameta.allure.entity.TestResult();
        dest.setUid(uidGenerator.get());
        dest.setHistoryId(result.getHistoryId());
        dest.setFullName(result.getFullName());
        dest.setName(Allure2Plugin.firstNonNull(result.getName(), result.getFullName(), "Unknown test"));
        dest.setTime(Time.create((Long)result.getStart(), (Long)result.getStop()));
        dest.setDescription(result.getDescription());
        dest.setDescriptionHtml(result.getDescriptionHtml());
        dest.setStatus(this.convert(result.getStatus()));
        Optional.ofNullable(result.getStatusDetails()).ifPresent(details -> {
            dest.setStatusMessage(details.getMessage());
            dest.setStatusTrace(details.getTrace());
            dest.setFlaky(details.isFlaky());
        });
        dest.setLinks(ConvertUtils.convertList((Collection)result.getLinks(), this::convert));
        dest.setLabels(ConvertUtils.convertList((Collection)result.getLabels(), this::convert));
        dest.setParameters(this.getParameters(result));
        dest.addLabelIfNotExists(LabelName.RESULT_FORMAT, ALLURE2_RESULTS_FORMAT);
        if (this.hasTestStage(result)) {
            dest.setTestStage(this.getTestStage(resultsDirectory, visitor, result));
        }
        List<TestResultContainer> parents = this.findAllParents(groups, result.getUuid(), new HashSet<String>());
        dest.getBeforeStages().addAll(this.getStages(parents, fixture -> this.getBefore(resultsDirectory, visitor, (TestResultContainer)fixture)));
        dest.getAfterStages().addAll(this.getStages(parents, fixture -> this.getAfter(resultsDirectory, visitor, (TestResultContainer)fixture)));
        visitor.visitTestResult(dest);
    }

    private StageResult convert(Path source, ResultsVisitor visitor, FixtureResult result) {
        StageResult stageResult = new StageResult().setName(result.getName()).setTime(this.convert(result.getStart(), result.getStop())).setStatus(this.convert(result.getStatus())).setSteps(ConvertUtils.convertList((Collection)result.getSteps(), step -> this.convert(source, visitor, (StepResult)step))).setDescription(result.getDescription()).setDescriptionHtml(result.getDescriptionHtml()).setAttachments(ConvertUtils.convertList((Collection)result.getAttachments(), attach -> this.convert(source, visitor, (Attachment)attach))).setParameters(ConvertUtils.convertList((Collection)result.getParameters(), p -> !Parameter.Mode.HIDDEN.equals((Object)p.getMode()), this::convert));
        Optional.of(result).map(FixtureResult::getStatusDetails).ifPresent(statusDetails -> {
            stageResult.setStatusMessage(statusDetails.getMessage());
            stageResult.setStatusTrace(statusDetails.getTrace());
        });
        return stageResult;
    }

    private io.qameta.allure.entity.Link convert(Link link) {
        return new io.qameta.allure.entity.Link().setName(link.getName()).setType(link.getType()).setUrl(link.getUrl());
    }

    private io.qameta.allure.entity.Label convert(Label label) {
        return new io.qameta.allure.entity.Label().setName(label.getName()).setValue(label.getValue());
    }

    private Parameter convert(io.qameta.allure.model.Parameter parameter) {
        boolean masked = Parameter.Mode.MASKED.equals((Object)parameter.getMode());
        return new Parameter().setName(parameter.getName()).setValue(masked ? "******" : parameter.getValue());
    }

    private io.qameta.allure.entity.Attachment convert(Path source, ResultsVisitor visitor, Attachment attachment) {
        Path attachmentFile = source.resolve(attachment.getSource());
        if (Files.isRegularFile(attachmentFile, new LinkOption[0])) {
            io.qameta.allure.entity.Attachment found = visitor.visitAttachmentFile(attachmentFile);
            if (Objects.nonNull(attachment.getType())) {
                found.setType(attachment.getType());
            }
            if (Objects.nonNull(attachment.getName())) {
                found.setName(attachment.getName());
            }
            return found;
        }
        visitor.error("Could not find attachment " + attachment.getSource() + " in directory " + source);
        return new io.qameta.allure.entity.Attachment().setType(attachment.getType()).setName(attachment.getName()).setSize(Long.valueOf(0L));
    }

    private Step convert(Path source, ResultsVisitor visitor, StepResult step) {
        Step result = new Step().setName(step.getName()).setStatus(this.convert(step.getStatus())).setTime(this.convert(step.getStart(), step.getStop())).setParameters(ConvertUtils.convertList((Collection)step.getParameters(), p -> !Parameter.Mode.HIDDEN.equals((Object)p.getMode()), this::convert)).setAttachments(ConvertUtils.convertList((Collection)step.getAttachments(), attachment -> this.convert(source, visitor, (Attachment)attachment))).setSteps(ConvertUtils.convertList((Collection)step.getSteps(), s -> this.convert(source, visitor, (StepResult)s)));
        Optional.of(step).map(StepResult::getStatusDetails).ifPresent(statusDetails -> {
            result.setStatusMessage(statusDetails.getMessage());
            result.setStatusTrace(statusDetails.getTrace());
        });
        return result;
    }

    private Status convert(io.qameta.allure.model.Status status) {
        if (Objects.isNull(status)) {
            return Status.UNKNOWN;
        }
        return Stream.of(Status.values()).filter(item -> item.value().equalsIgnoreCase(status.value())).findAny().orElse(Status.UNKNOWN);
    }

    private Time convert(Long start, Long stop) {
        return new Time().setStart(start).setStop(stop).setDuration(Objects.nonNull(start) && Objects.nonNull(stop) ? Long.valueOf(stop - start) : null);
    }

    private List<Parameter> getParameters(TestResult result) {
        TreeSet<Parameter> parametersSet = new TreeSet<Parameter>(Comparator.comparing(Parameter::getName, Comparator.nullsFirst(Comparator.naturalOrder())).thenComparing(Parameter::getValue, Comparator.nullsFirst(Comparator.naturalOrder())));
        parametersSet.addAll(ConvertUtils.convertList((Collection)result.getParameters(), p -> !Parameter.Mode.HIDDEN.equals((Object)p.getMode()), this::convert));
        return new ArrayList<Parameter>(parametersSet);
    }

    private StageResult getTestStage(Path source, ResultsVisitor visitor, TestResult result) {
        StageResult testStage = new StageResult();
        testStage.setSteps(ConvertUtils.convertList((Collection)result.getSteps(), step -> this.convert(source, visitor, (StepResult)step)));
        testStage.setAttachments(ConvertUtils.convertList((Collection)result.getAttachments(), attachment -> this.convert(source, visitor, (Attachment)attachment)));
        testStage.setStatus(this.convert(result.getStatus()));
        testStage.setDescription(result.getDescription());
        testStage.setDescriptionHtml(result.getDescriptionHtml());
        Optional.of(result).map(TestResult::getStatusDetails).ifPresent(statusDetails -> {
            testStage.setStatusMessage(statusDetails.getMessage());
            testStage.setStatusTrace(statusDetails.getTrace());
        });
        return testStage;
    }

    private boolean hasTestStage(TestResult result) {
        return !result.getSteps().isEmpty() || !result.getAttachments().isEmpty();
    }

    private List<StageResult> getStages(List<TestResultContainer> parents, Function<TestResultContainer, Stream<StageResult>> getter) {
        return parents.stream().flatMap(getter).sorted(BY_START).collect(Collectors.toList());
    }

    private Stream<StageResult> getBefore(Path source, ResultsVisitor visitor, TestResultContainer container) {
        return ConvertUtils.convertList((Collection)container.getBefores(), fixture -> this.convert(source, visitor, (FixtureResult)fixture)).stream();
    }

    private Stream<StageResult> getAfter(Path source, ResultsVisitor visitor, TestResultContainer container) {
        return ConvertUtils.convertList((Collection)container.getAfters(), fixture -> this.convert(source, visitor, (FixtureResult)fixture)).stream();
    }

    private List<TestResultContainer> findAllParents(List<TestResultContainer> groups, String id, Set<String> seen) {
        List<TestResultContainer> parents = this.findParents(groups, id, seen);
        ArrayList<TestResultContainer> result = new ArrayList<TestResultContainer>(parents);
        for (TestResultContainer container : parents) {
            result.addAll(this.findAllParents(groups, container.getUuid(), seen));
        }
        return result;
    }

    private List<TestResultContainer> findParents(List<TestResultContainer> groups, String id, Set<String> seen) {
        return groups.stream().filter(container -> container.getChildren().contains(id)).filter(container -> !seen.contains(container.getUuid())).collect(Collectors.toList());
    }

    @SafeVarargs
    private static <T> T firstNonNull(T ... items) {
        return (T)Stream.of(items).filter(Objects::nonNull).findFirst().orElseThrow(() -> new IllegalStateException("firstNonNull method should have at least one non null parameter"));
    }

    private Stream<TestResultContainer> readTestResultsContainers(Path resultsDirectory) {
        return this.listFiles(resultsDirectory, "*-container.json").map(this::readTestResultContainer).filter(Optional::isPresent).map(Optional::get);
    }

    private Stream<TestResult> readTestResults(Path resultsDirectory) {
        return this.listFiles(resultsDirectory, "*-result.json").map(this::readTestResult).filter(Optional::isPresent).map(Optional::get);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Optional<TestResult> readTestResult(Path file) {
        try (InputStream is = Files.newInputStream(file, new OpenOption[0]);){
            Optional<Object> optional = Optional.ofNullable(this.mapper.readValue(is, TestResult.class));
            return optional;
        }
        catch (IOException e) {
            LOGGER.error("Could not read test result file {}", (Object)file, (Object)e);
            return Optional.empty();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Optional<TestResultContainer> readTestResultContainer(Path file) {
        try (InputStream is = Files.newInputStream(file, new OpenOption[0]);){
            Optional<Object> optional = Optional.ofNullable(this.mapper.readValue(is, TestResultContainer.class));
            return optional;
        }
        catch (IOException e) {
            LOGGER.error("Could not read result container file {}", (Object)file, (Object)e);
            return Optional.empty();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Stream<Path> listFiles(Path directory, String glob) {
        try (DirectoryStream<Path> directoryStream = Files.newDirectoryStream(directory, glob);){
            Stream<Path> stream = StreamSupport.stream(directoryStream.spliterator(), false).filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).collect(Collectors.toList()).stream();
            return stream;
        }
        catch (IOException e) {
            LOGGER.error("Could not list files in directory {}", (Object)directory, (Object)e);
            return Stream.empty();
        }
    }
}

