/*
 * Decompiled with CFR 0.152.
 */
package io.qameta.allure.core;

import io.qameta.allure.Aggregator;
import io.qameta.allure.core.Configuration;
import io.qameta.allure.core.LaunchResults;
import io.qameta.allure.entity.Attachment;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.List;

public class AttachmentsPlugin
implements Aggregator {
    public void aggregate(Configuration configuration, List<LaunchResults> launchesResults, Path outputDirectory) throws IOException {
        Path attachmentsFolder = Files.createDirectories(outputDirectory.resolve("data").resolve("attachments"), new FileAttribute[0]);
        launchesResults.forEach(launch -> launch.getAttachments().entrySet().parallelStream().forEach(entry -> {
            Path file = attachmentsFolder.resolve(((Attachment)entry.getValue()).getSource());
            try {
                Files.copy((Path)entry.getKey(), file, StandardCopyOption.REPLACE_EXISTING);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }));
    }
}

