/*
 * Decompiled with CFR 0.152.
 */
package io.qameta.allure.core;

import io.qameta.allure.Aggregator;
import io.qameta.allure.context.JacksonContext;
import io.qameta.allure.core.Configuration;
import io.qameta.allure.core.LaunchResults;
import io.qameta.allure.entity.TestResult;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.stream.Collectors;

public class TestsResultsPlugin
implements Aggregator {
    public void aggregate(Configuration configuration, List<LaunchResults> launchesResults, Path outputDirectory) throws IOException {
        JacksonContext context = (JacksonContext)configuration.requireContext(JacksonContext.class);
        Path testCasesFolder = Files.createDirectories(outputDirectory.resolve("data").resolve("test-cases"), new FileAttribute[0]);
        List results = launchesResults.stream().flatMap(launch -> launch.getAllResults().stream()).collect(Collectors.toList());
        for (TestResult result : results) {
            Path file = testCasesFolder.resolve(result.getSource());
            OutputStream os = Files.newOutputStream(file, new OpenOption[0]);
            try {
                context.getValue().writeValue(os, (Object)result);
            }
            finally {
                if (os == null) continue;
                os.close();
            }
        }
    }
}

