/*
 * Decompiled with CFR 0.152.
 */
package io.qameta.allure.duration;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.qameta.allure.Aggregator;
import io.qameta.allure.CommonJsonAggregator;
import io.qameta.allure.core.LaunchResults;
import io.qameta.allure.duration.DurationTrendItem;
import io.qameta.allure.trend.AbstractTrendPlugin;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class DurationTrendPlugin
extends AbstractTrendPlugin<DurationTrendItem> {
    protected static final String JSON_FILE_NAME = "duration-trend.json";
    private static final String DURATION_TREND_BLOCK_NAME = "duration-trend";

    public DurationTrendPlugin() {
        super(Arrays.asList(new Aggregator[]{new JsonAggregator(), new WidgetAggregator()}), JSON_FILE_NAME, DURATION_TREND_BLOCK_NAME);
    }

    @Override
    protected Optional<DurationTrendItem> parseItem(ObjectMapper mapper, JsonNode child) throws JsonProcessingException {
        return Optional.ofNullable((DurationTrendItem)mapper.treeToValue((TreeNode)child, DurationTrendItem.class));
    }

    static List<DurationTrendItem> getData(List<LaunchResults> launchesResults) {
        DurationTrendItem item = DurationTrendPlugin.createCurrent(launchesResults);
        List<DurationTrendItem> data = DurationTrendPlugin.getHistoryItems(launchesResults);
        return Stream.concat(Stream.of(item), data.stream()).limit(20L).collect(Collectors.toList());
    }

    private static List<DurationTrendItem> getHistoryItems(List<LaunchResults> launchesResults) {
        return launchesResults.stream().map(DurationTrendPlugin::getPreviousTrendData).reduce(new ArrayList(), (first, second) -> {
            first.addAll(second);
            return first;
        });
    }

    private static List<DurationTrendItem> getPreviousTrendData(LaunchResults results) {
        return (List)results.getExtra(DURATION_TREND_BLOCK_NAME, ArrayList::new);
    }

    private static DurationTrendItem createCurrent(List<LaunchResults> launchesResults) {
        DurationTrendItem item = new DurationTrendItem();
        DurationTrendPlugin.extractLatestExecutor(launchesResults).ifPresent(info -> {
            item.setBuildOrder(info.getBuildOrder());
            item.setReportName(info.getReportName());
            item.setReportUrl(info.getReportUrl());
        });
        launchesResults.stream().flatMap(launch -> launch.getResults().stream()).forEach(item::updateTime);
        return item;
    }

    private static class JsonAggregator
    extends CommonJsonAggregator {
        JsonAggregator() {
            super("history", DurationTrendPlugin.JSON_FILE_NAME);
        }

        protected List<DurationTrendItem> getData(List<LaunchResults> launches) {
            return DurationTrendPlugin.getData(launches);
        }
    }

    private static class WidgetAggregator
    extends CommonJsonAggregator {
        WidgetAggregator() {
            super("widgets", DurationTrendPlugin.JSON_FILE_NAME);
        }

        public List<DurationTrendItem> getData(List<LaunchResults> launches) {
            return DurationTrendPlugin.getData(launches);
        }
    }
}

