/*
 * Decompiled with CFR 0.152.
 */
package io.qameta.allure.history;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.qameta.allure.Aggregator;
import io.qameta.allure.CommonJsonAggregator;
import io.qameta.allure.core.LaunchResults;
import io.qameta.allure.entity.Statistic;
import io.qameta.allure.entity.TestResult;
import io.qameta.allure.history.HistoryTrendItem;
import io.qameta.allure.trend.AbstractTrendPlugin;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class HistoryTrendPlugin
extends AbstractTrendPlugin<HistoryTrendItem> {
    public static final String JSON_FILE_NAME = "history-trend.json";
    public static final String HISTORY_TREND_BLOCK_NAME = "history-trend";

    public HistoryTrendPlugin() {
        super(Arrays.asList(new Aggregator[]{new JsonAggregator(), new WidgetAggregator()}), JSON_FILE_NAME, HISTORY_TREND_BLOCK_NAME);
    }

    @Override
    protected Optional<HistoryTrendItem> parseItem(ObjectMapper mapper, JsonNode child) throws JsonProcessingException {
        if (Objects.nonNull(child.get("total"))) {
            Statistic statistic = (Statistic)mapper.treeToValue((TreeNode)child, Statistic.class);
            return Optional.of(new HistoryTrendItem().setStatistic(statistic));
        }
        return Optional.ofNullable((HistoryTrendItem)mapper.treeToValue((TreeNode)child, HistoryTrendItem.class));
    }

    static List<HistoryTrendItem> getData(List<LaunchResults> launchesResults) {
        HistoryTrendItem item = HistoryTrendPlugin.createCurrent(launchesResults);
        List<HistoryTrendItem> data = HistoryTrendPlugin.getHistoryItems(launchesResults);
        return Stream.concat(Stream.of(item), data.stream()).limit(20L).collect(Collectors.toList());
    }

    private static HistoryTrendItem createCurrent(List<LaunchResults> launchesResults) {
        Statistic statistic = launchesResults.stream().flatMap(results -> results.getResults().stream()).map(TestResult::getStatus).collect(Statistic::new, Statistic::update, Statistic::merge);
        HistoryTrendItem item = new HistoryTrendItem().setStatistic(statistic);
        HistoryTrendPlugin.extractLatestExecutor(launchesResults).ifPresent(info -> {
            item.setBuildOrder(info.getBuildOrder());
            item.setReportName(info.getReportName());
            item.setReportUrl(info.getReportUrl());
        });
        return item;
    }

    private static List<HistoryTrendItem> getHistoryItems(List<LaunchResults> launchesResults) {
        return launchesResults.stream().map(HistoryTrendPlugin::getPreviousTrendData).reduce(new ArrayList(), (first, second) -> {
            first.addAll(second);
            return first;
        });
    }

    private static List<HistoryTrendItem> getPreviousTrendData(LaunchResults results) {
        return (List)results.getExtra(HISTORY_TREND_BLOCK_NAME, ArrayList::new);
    }

    protected static class JsonAggregator
    extends CommonJsonAggregator {
        JsonAggregator() {
            super("history", HistoryTrendPlugin.JSON_FILE_NAME);
        }

        protected List<HistoryTrendItem> getData(List<LaunchResults> launches) {
            return HistoryTrendPlugin.getData(launches);
        }
    }

    private static class WidgetAggregator
    extends CommonJsonAggregator {
        WidgetAggregator() {
            super("widgets", HistoryTrendPlugin.JSON_FILE_NAME);
        }

        public List<HistoryTrendItem> getData(List<LaunchResults> launches) {
            return HistoryTrendPlugin.getData(launches);
        }
    }
}

