/*
 * Decompiled with CFR 0.152.
 */
package io.qameta.allure.severity;

import io.qameta.allure.Aggregator;
import io.qameta.allure.CommonJsonAggregator;
import io.qameta.allure.CompositeAggregator;
import io.qameta.allure.core.Configuration;
import io.qameta.allure.core.LaunchResults;
import io.qameta.allure.entity.LabelName;
import io.qameta.allure.entity.TestResult;
import io.qameta.allure.severity.SeverityData;
import io.qameta.allure.severity.SeverityLevel;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

public class SeverityPlugin
extends CompositeAggregator {
    public static final String SEVERITY_BLOCK_NAME = "severity";
    protected static final String JSON_FILE_NAME = "severity.json";

    public SeverityPlugin() {
        super(Arrays.asList(new Aggregator[]{new SeverityAggregator(), new WidgetAggregator()}));
    }

    private static class SeverityAggregator
    implements Aggregator {
        private SeverityAggregator() {
        }

        public void aggregate(Configuration configuration, List<LaunchResults> launchesResults, Path outputDirectory) {
            launchesResults.stream().flatMap(results -> results.getResults().stream()).forEach(this::setSeverityLevel);
        }

        private void setSeverityLevel(TestResult result) {
            SeverityLevel severityLevel = result.findOneLabel(LabelName.SEVERITY).flatMap(SeverityLevel::fromValue).orElse(SeverityLevel.NORMAL);
            result.addExtraBlock(SeverityPlugin.SEVERITY_BLOCK_NAME, (Object)severityLevel);
        }
    }

    private static class WidgetAggregator
    extends CommonJsonAggregator {
        WidgetAggregator() {
            super("widgets", SeverityPlugin.JSON_FILE_NAME);
        }

        protected List<SeverityData> getData(List<LaunchResults> launchesResults) {
            return launchesResults.stream().flatMap(launch -> launch.getResults().stream()).map(this::createData).collect(Collectors.toList());
        }

        private SeverityData createData(TestResult result) {
            return new SeverityData().setUid(result.getUid()).setName(result.getName()).setStatus(result.getStatus()).setTime(result.getTime()).setSeverity((SeverityLevel)result.getExtraBlock(SeverityPlugin.SEVERITY_BLOCK_NAME));
        }
    }
}

