/*
 * Decompiled with CFR 0.152.
 */
package io.qameta.allure.core;

import freemarker.template.Template;
import io.qameta.allure.PluginConfiguration;
import io.qameta.allure.ReportGenerationException;
import io.qameta.allure.ReportStorage;
import io.qameta.allure.context.FreemarkerContext;
import io.qameta.allure.core.Configuration;
import io.qameta.allure.core.InMemoryReportStorage;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Base64;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Objects;
import java.util.UUID;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;

public class ReportWebGenerator {
    private static final String FAVICON_ICO = "favicon.ico";
    private static final String STYLES_CSS = "styles.css";
    private static final String APP_JS = "app.js";
    private static final String TEXT_JAVASCRIPT = "text/javascript";
    private static final String TEXT_CSS = "text/css";

    public void generate(Configuration configuration, ReportStorage reportStorage, Path outputDirectory) {
        boolean inline = reportStorage instanceof InMemoryReportStorage;
        HashSet<String> jsFiles = new HashSet<String>();
        if (inline) {
            jsFiles.add(ReportWebGenerator.dataBase64(TEXT_JAVASCRIPT, APP_JS));
        } else {
            jsFiles.add(APP_JS);
            ReportWebGenerator.write(outputDirectory, APP_JS, ReportWebGenerator.readResource(APP_JS));
        }
        HashSet<String> cssFiles = new HashSet<String>();
        if (inline) {
            cssFiles.add(ReportWebGenerator.dataBase64(TEXT_CSS, STYLES_CSS));
        } else {
            cssFiles.add(STYLES_CSS);
            ReportWebGenerator.write(outputDirectory, STYLES_CSS, ReportWebGenerator.readResource(STYLES_CSS));
        }
        configuration.getPlugins().forEach(plugin -> {
            HashMap<String, Path> pluginFiles = new HashMap<String, Path>(plugin.getPluginFiles());
            PluginConfiguration config = plugin.getConfig();
            config.getJsFiles().forEach(jsFile -> {
                Path jsFilePath = (Path)pluginFiles.remove(jsFile);
                if (inline) {
                    jsFiles.add(ReportWebGenerator.dataBase64(TEXT_JAVASCRIPT, jsFilePath));
                } else {
                    String key = ReportWebGenerator.pluginFileKey(config, jsFile);
                    jsFiles.add(key);
                    ReportWebGenerator.write(outputDirectory, key, jsFilePath);
                }
            });
            config.getCssFiles().forEach(cssFile -> {
                Path cssFilePath = (Path)pluginFiles.remove(cssFile);
                if (inline) {
                    cssFiles.add(ReportWebGenerator.dataBase64(TEXT_CSS, cssFilePath));
                } else {
                    String key = ReportWebGenerator.pluginFileKey(config, cssFile);
                    cssFiles.add(key);
                    ReportWebGenerator.write(outputDirectory, key, cssFilePath);
                }
            });
            pluginFiles.forEach((key, path) -> {
                String pluginFileKey = ReportWebGenerator.pluginFileKey(config, key);
                ReportWebGenerator.write(outputDirectory, pluginFileKey, path);
            });
        });
        FreemarkerContext context = (FreemarkerContext)configuration.requireContext(FreemarkerContext.class);
        try (BufferedWriter writer = Files.newBufferedWriter(Files.createDirectories(outputDirectory, new FileAttribute[0]).resolve("index.html"), StandardCharsets.UTF_8, new OpenOption[0]);){
            String faviconUrl;
            Template template = context.getValue().getTemplate("index.html.ftl");
            HashMap<String, Object> dataModel = new HashMap<String, Object>();
            String string = faviconUrl = inline ? ReportWebGenerator.dataBase64("image/x-icon", FAVICON_ICO) : FAVICON_ICO;
            if (!inline) {
                ReportWebGenerator.write(outputDirectory, FAVICON_ICO, ReportWebGenerator.readResource(FAVICON_ICO));
            }
            dataModel.put("faviconUrl", faviconUrl);
            dataModel.put("stylesUrls", cssFiles);
            dataModel.put("jsUrls", jsFiles);
            if (inline) {
                HashMap<String, String> reportDataFiles = new HashMap<String, String>(((InMemoryReportStorage)reportStorage).getReportDataFiles());
                dataModel.put("reportDataFiles", reportDataFiles);
            }
            dataModel.put("analyticsDisable", false);
            dataModel.put("reportUuid", UUID.randomUUID().toString());
            dataModel.put("allureVersion", "dev");
            template.process(dataModel, (Writer)writer);
        }
        catch (Exception e) {
            throw new ReportGenerationException("could not generate report web", e);
        }
    }

    private static String pluginFileKey(PluginConfiguration config, String cssFile) {
        return "plugin/" + config.getId() + "/" + cssFile;
    }

    private static byte[] readResource(String resourceName) {
        byte[] byArray;
        block9: {
            InputStream is = Thread.currentThread().getContextClassLoader().getResourceAsStream(resourceName);
            try {
                if (Objects.isNull(is)) {
                    throw new ReportGenerationException(String.format("Resource %s not found", resourceName));
                }
                byArray = IOUtils.toByteArray((InputStream)is);
                if (is == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new ReportGenerationException("Can't read resource " + resourceName, e);
                }
            }
            is.close();
        }
        return byArray;
    }

    private static String dataBase64(String contentType, String resourceName) {
        byte[] resource = ReportWebGenerator.readResource(resourceName);
        return ReportWebGenerator.dataUrl(contentType, resource);
    }

    private static String dataBase64(String contentType, Path path) {
        try {
            byte[] bytes = FileUtils.readFileToByteArray((File)path.toFile());
            return ReportWebGenerator.dataUrl(contentType, bytes);
        }
        catch (IOException e) {
            throw new ReportGenerationException("Can't read file " + path, e);
        }
    }

    private static String dataUrl(String contentType, byte[] resource) {
        return String.format("data:%s;base64,%s", contentType, Base64.getEncoder().encodeToString(resource));
    }

    private static void write(Path outputDirectory, String name, byte[] bytes) {
        try {
            Path target = outputDirectory.resolve(name);
            Files.createDirectories(target.getParent(), new FileAttribute[0]);
            Files.write(target, bytes, new OpenOption[0]);
        }
        catch (IOException e) {
            throw new ReportGenerationException("Can't write bytes " + name, e);
        }
    }

    private static void write(Path outputDirectory, String name, Path path) {
        try {
            Path target = outputDirectory.resolve(name);
            Files.createDirectories(target.getParent(), new FileAttribute[0]);
            Files.copy(path, target, StandardCopyOption.REPLACE_EXISTING);
        }
        catch (IOException e) {
            throw new ReportGenerationException("Can't write file " + name, e);
        }
    }
}

