/*
 * Decompiled with CFR 0.152.
 */
package io.qameta.allure.core;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.json.JsonMapper;
import io.qameta.allure.ReportGenerationException;
import io.qameta.allure.ReportStorage;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;

public class FileSystemReportStorage
implements ReportStorage {
    private final JsonMapper mapper = (JsonMapper)((JsonMapper.Builder)JsonMapper.builder().serializationInclusion(JsonInclude.Include.NON_NULL)).build();
    private final Path dataDirectory;

    public FileSystemReportStorage(Path reportDirectory) {
        this.dataDirectory = reportDirectory;
    }

    public void addDataJson(String name, Object data) {
        Path target = this.getPath(name);
        try (OutputStream os = Files.newOutputStream(target, new OpenOption[0]);){
            this.mapper.writeValue(os, data);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public void addDataBinary(String name, byte[] data) {
        Path target = this.getPath(name);
        try {
            Files.write(target, data, new OpenOption[0]);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public void addDataFile(String name, Path file) {
        Path target = this.getPath(name);
        try {
            Files.copy(file, target, StandardCopyOption.REPLACE_EXISTING);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private Path getPath(String name) {
        Path normalized = FileSystemReportStorage.checkPath(name);
        Path target = this.dataDirectory.resolve(normalized);
        FileSystemReportStorage.createDirectories(target.getParent());
        return target;
    }

    private static void createDirectories(Path target) {
        try {
            Files.createDirectories(target, new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private static Path checkPath(String name) {
        Path resource = Paths.get(name, new String[0]);
        if (resource.isAbsolute()) {
            throw new ReportGenerationException("absolute resource names are forbidden");
        }
        Path normalized = resource.normalize();
        if (!normalized.equals(resource)) {
            throw new ReportGenerationException("only normalized resource names are supported");
        }
        return normalized;
    }
}

