/*
 * Decompiled with CFR 0.152.
 */
package io.qameta.allure.core;

import freemarker.template.Template;
import freemarker.template.TemplateException;
import io.qameta.allure.Aggregator;
import io.qameta.allure.ReportGenerationException;
import io.qameta.allure.context.FreemarkerContext;
import io.qameta.allure.core.Configuration;
import io.qameta.allure.core.LaunchResults;
import io.qameta.allure.core.Plugin;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
public class ReportWebPlugin
implements Aggregator {
    private static final Logger LOGGER = LoggerFactory.getLogger(ReportWebPlugin.class);
    private final List<String> staticFiles = Arrays.asList("app.js", "styles.css", "favicon.ico");

    public void aggregate(Configuration configuration, List<LaunchResults> launchesResults, Path outputDirectory) throws IOException {
        this.writePluginsStatic(configuration, outputDirectory);
        this.writeIndexHtml(configuration, outputDirectory);
        this.writeStatic(outputDirectory);
    }

    protected void writePluginsStatic(Configuration configuration, Path outputDirectory) throws IOException {
        Path pluginsFolder = outputDirectory.resolve("plugins");
        for (Plugin plugin : configuration.getPlugins()) {
            Path pluginDirectory = Files.createDirectories(pluginsFolder.resolve(plugin.getConfig().getId()), new FileAttribute[0]);
            plugin.unpackReportStatic(pluginDirectory);
        }
    }

    protected void writeIndexHtml(Configuration configuration, Path outputDirectory) throws IOException {
        FreemarkerContext context = (FreemarkerContext)configuration.requireContext(FreemarkerContext.class);
        Path indexHtml = outputDirectory.resolve("index.html");
        List pluginConfigurations = configuration.getPlugins().stream().map(Plugin::getConfig).collect(Collectors.toList());
        try (BufferedWriter writer = Files.newBufferedWriter(indexHtml, new OpenOption[0]);){
            Template template = context.getValue().getTemplate("index.html.ftl");
            HashMap<String, Object> dataModel = new HashMap<String, Object>();
            dataModel.put("plugins", pluginConfigurations);
            Boolean noAnalytics = Optional.ofNullable(System.getenv("ALLURE_NO_ANALYTICS")).map(Boolean::parseBoolean).orElse(false);
            dataModel.put("ALLURE_NO_ANALYTICS", noAnalytics);
            dataModel.put("reportUuid", configuration.getUuid());
            dataModel.put("allureVersion", configuration.getVersion());
            template.process(dataModel, (Writer)writer);
        }
        catch (TemplateException e) {
            LOGGER.error("Couldn't write index file", (Throwable)e);
        }
    }

    protected void writeStatic(Path outputDirectory) {
        this.staticFiles.forEach(resourceName -> {
            try (InputStream is = Thread.currentThread().getContextClassLoader().getResourceAsStream((String)resourceName);){
                if (Objects.isNull(is)) {
                    throw new ReportGenerationException(String.format("Resource %s not found", resourceName));
                }
                Files.copy(is, outputDirectory.resolve((String)resourceName), StandardCopyOption.REPLACE_EXISTING);
            }
            catch (IOException e) {
                LOGGER.error("Couldn't unpack report static");
            }
        });
    }
}

