/*
 * Decompiled with CFR 0.152.
 */
package io.qameta.allure.influxdb;

import io.qameta.allure.CommonMetricAggregator2;
import io.qameta.allure.category.CategoriesMetric;
import io.qameta.allure.influxdb.InfluxDbMetricLine;
import io.qameta.allure.metric.Metric;
import io.qameta.allure.metric.StatusMetric;
import io.qameta.allure.metric.TimeMetric;
import io.qameta.allure.retry.RetryMetric;
import java.time.Instant;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.TimeUnit;

public class InfluxDbExportPlugin
extends CommonMetricAggregator2 {
    public InfluxDbExportPlugin() {
        super("influxDbData.txt");
    }

    public List<Metric> getMetrics() {
        long timestamp = TimeUnit.SECONDS.toNanos(Instant.now().getEpochSecond());
        StatusMetric statusMetric = new StatusMetric((status, count) -> new InfluxDbMetricLine("launch_status", status.value(), String.valueOf(count), timestamp));
        TimeMetric timeMetric = new TimeMetric((key, time) -> new InfluxDbMetricLine("launch_time", (String)key, String.valueOf(time), timestamp));
        CategoriesMetric categoriesMetric = new CategoriesMetric((category, count) -> new InfluxDbMetricLine("launch_problems", (String)category, String.valueOf(count), timestamp));
        RetryMetric retryMetric = new RetryMetric((key, count) -> new InfluxDbMetricLine("launch_retries", (String)key, String.valueOf(count), timestamp));
        return Arrays.asList(statusMetric, timeMetric, categoriesMetric, retryMetric);
    }
}

