/*
 * Decompiled with CFR 0.152.
 */
package io.qameta.allure.core;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.json.JsonMapper;
import io.qameta.allure.ReportStorage;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Base64;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class InMemoryReportStorage
implements ReportStorage {
    private final Map<String, String> reportDataFiles = new ConcurrentHashMap<String, String>();
    private final JsonMapper mapper = (JsonMapper)((JsonMapper.Builder)JsonMapper.builder().serializationInclusion(JsonInclude.Include.NON_NULL)).build();

    public void addDataJson(String name, Object data) {
        try {
            byte[] bytes = this.mapper.writeValueAsBytes(data);
            this.addDataBinary(name, bytes);
        }
        catch (JsonProcessingException e) {
            throw new UncheckedIOException((IOException)((Object)e));
        }
    }

    public void addDataBinary(String name, byte[] data) {
        this.reportDataFiles.put(name, Base64.getEncoder().encodeToString(data));
    }

    public void addDataFile(String name, Path file) {
        try {
            byte[] bytes = Files.readAllBytes(file);
            this.addDataBinary(name, bytes);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public Map<String, String> getReportDataFiles() {
        return Collections.unmodifiableMap(this.reportDataFiles);
    }
}

