/*
 * Decompiled with CFR 0.152.
 */
package io.qameta.allure.grpc;

import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.MessageOrBuilder;
import com.google.protobuf.util.JsonFormat;
import io.grpc.CallOptions;
import io.grpc.Channel;
import io.grpc.ClientCall;
import io.grpc.ClientInterceptor;
import io.grpc.ForwardingClientCall;
import io.grpc.ForwardingClientCallListener;
import io.grpc.Metadata;
import io.grpc.MethodDescriptor;
import io.qameta.allure.Allure;
import io.qameta.allure.attachment.AttachmentData;
import io.qameta.allure.attachment.AttachmentProcessor;
import io.qameta.allure.attachment.AttachmentRenderer;
import io.qameta.allure.attachment.DefaultAttachmentProcessor;
import io.qameta.allure.attachment.FreemarkerAttachmentRenderer;
import io.qameta.allure.grpc.GrpcRequestAttachment;
import io.qameta.allure.grpc.GrpcResponseAttachment;
import io.qameta.allure.model.Status;
import io.qameta.allure.model.StatusDetails;
import io.qameta.allure.model.StepResult;
import io.qameta.allure.util.ResultsUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AllureGrpc
implements ClientInterceptor {
    private static final Logger LOGGER = LoggerFactory.getLogger(AllureGrpc.class);
    private static final JsonFormat.Printer JSON_PRINTER = JsonFormat.printer();
    private String requestTemplatePath = "grpc-request.ftl";
    private String responseTemplatePath = "grpc-response.ftl";
    private boolean markStepFailedOnNonZeroCode = true;
    private boolean interceptResponseMetadata;

    public AllureGrpc setRequestTemplate(String templatePath) {
        this.requestTemplatePath = templatePath;
        return this;
    }

    public AllureGrpc setResponseTemplate(String templatePath) {
        this.responseTemplatePath = templatePath;
        return this;
    }

    public AllureGrpc markStepFailedOnNonZeroCode(boolean value) {
        this.markStepFailedOnNonZeroCode = value;
        return this;
    }

    public AllureGrpc interceptResponseMetadata(boolean value) {
        this.interceptResponseMetadata = value;
        return this;
    }

    public <T, A> ClientCall<T, A> interceptCall(final MethodDescriptor<T, A> method, CallOptions callOptions, final Channel next) {
        DefaultAttachmentProcessor processor = new DefaultAttachmentProcessor();
        return new ForwardingClientCall.SimpleForwardingClientCall<T, A>(next.newCall(method, callOptions.withoutWaitForReady()), (AttachmentProcessor)processor){
            private String stepUuid;
            private List<String> parsedResponses;
            final /* synthetic */ AttachmentProcessor val$processor;
            {
                this.val$processor = attachmentProcessor;
                super(arg0);
                this.parsedResponses = new ArrayList<String>();
            }

            public void sendMessage(T message) {
                this.stepUuid = UUID.randomUUID().toString();
                Allure.getLifecycle().startStep(this.stepUuid, new StepResult().setName("Send gRPC request to " + next.authority() + this.trimGrpcMethodName(method.getFullMethodName())));
                try {
                    GrpcRequestAttachment rpcRequestAttach = GrpcRequestAttachment.Builder.create("gRPC request", method.getFullMethodName()).setBody(JSON_PRINTER.print((MessageOrBuilder)message)).build();
                    this.val$processor.addAttachment((AttachmentData)rpcRequestAttach, (AttachmentRenderer)new FreemarkerAttachmentRenderer(AllureGrpc.this.requestTemplatePath));
                    super.sendMessage(message);
                }
                catch (InvalidProtocolBufferException e) {
                    LOGGER.warn("Can`t parse gRPC request", (Throwable)e);
                }
                catch (Throwable e) {
                    Allure.getLifecycle().updateStep(stepResult -> stepResult.setStatus(ResultsUtils.getStatus((Throwable)e).orElse(Status.BROKEN)).setStatusDetails((StatusDetails)ResultsUtils.getStatusDetails((Throwable)e).orElse(null)));
                    Allure.getLifecycle().stopStep(this.stepUuid);
                    this.stepUuid = null;
                }
            }

            public void start(final ClientCall.Listener<A> responseListener, final Metadata headers) {
                ForwardingClientCallListener listener = new ForwardingClientCallListener<A>(){

                    protected ClientCall.Listener<A> delegate() {
                        return responseListener;
                    }

                    public void onClose(io.grpc.Status status, Metadata trailers) {
                        GrpcResponseAttachment.Builder responseAttachmentBuilder = null;
                        if (parsedResponses.size() == 1) {
                            responseAttachmentBuilder = GrpcResponseAttachment.Builder.create("gRPC response").setBody((String)parsedResponses.iterator().next());
                        } else if (parsedResponses.size() > 1) {
                            responseAttachmentBuilder = GrpcResponseAttachment.Builder.create("gRPC response (collection of elements from Server stream)").setBody("[" + String.join((CharSequence)",\n", parsedResponses) + "]");
                        }
                        if (!status.isOk()) {
                            String description = status.getDescription();
                            if (description == null) {
                                description = "No description provided";
                            }
                            responseAttachmentBuilder = GrpcResponseAttachment.Builder.create(status.getCode().name()).setStatus(description);
                        }
                        Objects.requireNonNull(responseAttachmentBuilder).setStatus(status.toString());
                        if (AllureGrpc.this.interceptResponseMetadata) {
                            for (String key : headers.keys()) {
                                Objects.requireNonNull(responseAttachmentBuilder).setMetadata(key, (String)headers.get(Metadata.Key.of((String)key, (Metadata.AsciiMarshaller)Metadata.ASCII_STRING_MARSHALLER)));
                            }
                        }
                        val$processor.addAttachment((AttachmentData)Objects.requireNonNull(responseAttachmentBuilder).build(), (AttachmentRenderer)new FreemarkerAttachmentRenderer(AllureGrpc.this.responseTemplatePath));
                        if (status.isOk() || !AllureGrpc.this.markStepFailedOnNonZeroCode) {
                            Allure.getLifecycle().updateStep(stepUuid, step -> step.setStatus(Status.PASSED));
                        } else {
                            Allure.getLifecycle().updateStep(stepUuid, step -> step.setStatus(Status.FAILED));
                        }
                        Allure.getLifecycle().stopStep(stepUuid);
                        stepUuid = null;
                        super.onClose(status, trailers);
                    }

                    public void onMessage(A message) {
                        try {
                            parsedResponses.add(JSON_PRINTER.print((MessageOrBuilder)message));
                            super.onMessage(message);
                        }
                        catch (InvalidProtocolBufferException e) {
                            LOGGER.warn("Can`t parse gRPC response", (Throwable)e);
                        }
                        catch (Throwable e) {
                            Allure.getLifecycle().updateStep(step -> step.setStatus(ResultsUtils.getStatus((Throwable)e).orElse(Status.BROKEN)).setStatusDetails((StatusDetails)ResultsUtils.getStatusDetails((Throwable)e).orElse(null)));
                            Allure.getLifecycle().stopStep(stepUuid);
                            stepUuid = null;
                        }
                    }
                };
                super.start((ClientCall.Listener)listener, headers);
            }

            private String trimGrpcMethodName(String source) {
                return source.substring(source.lastIndexOf(47));
            }
        };
    }
}

