/*
 * Decompiled with CFR 0.152.
 */
package io.qameta.allure.grpc;

import io.qameta.allure.attachment.AttachmentData;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class GrpcResponseAttachment
implements AttachmentData {
    private final String name;
    private final String body;
    private final String status;
    private final Map<String, String> metadata;

    public GrpcResponseAttachment(String name, String body, String status, Map<String, String> metadata) {
        this.name = name;
        this.body = body;
        this.status = status;
        this.metadata = metadata;
    }

    public String getBody() {
        return this.body;
    }

    public Map<String, String> getMetadata() {
        return this.metadata;
    }

    public String getStatus() {
        return this.status;
    }

    public String getName() {
        return this.name;
    }

    static final class Builder {
        private final String name;
        private final Map<String, String> metadata = new HashMap<String, String>();
        private String body;
        private String status;

        private Builder(String name) {
            Objects.requireNonNull(name, "Name must not be null value");
            this.name = name;
        }

        public static Builder create(String attachmentName) {
            return new Builder(attachmentName);
        }

        public Builder setBody(String body) {
            Objects.requireNonNull(body, "Body should not be null value");
            this.body = body;
            return this;
        }

        public Builder setStatus(String status) {
            Objects.requireNonNull(status, "Status should not be null value");
            this.status = status;
            return this;
        }

        public Builder setMetadata(String key, String value) {
            Objects.requireNonNull(key, "Matadata key must not be null value");
            Objects.requireNonNull(value, "Matadata value must not be null value");
            this.metadata.put(key, value);
            return this;
        }

        public Builder addMetadata(Map<String, String> metadata) {
            Objects.requireNonNull(metadata, "Metadata Map must not be null value");
            this.metadata.putAll(metadata);
            return this;
        }

        public GrpcResponseAttachment build() {
            return new GrpcResponseAttachment(this.name, this.body, this.status, this.metadata);
        }
    }
}

